/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.guis;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.guis.MainGui;
import com.artillexstudios.axinventoryrestore.guis.PreviewGui;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.libs.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.Gui;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.GuiItem;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.PaginatedGui;
import com.artillexstudios.axinventoryrestore.utils.DateUtils;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CategoryGui {
    private final PaginatedGui categoryGui;
    private final MainGui mainGui;
    private final Player viewer;
    private final UUID restoreUser;
    private final List<BackupData> backupDataList;
    private final PaginatedGui lastGui;
    private final int pageNum;
    private final int rows = AxInventoryRestore.CONFIG.getInt("menu-rows.backup-selector", 4);

    public CategoryGui(@NotNull MainGui mainGui, List<BackupData> backupDataList, PaginatedGui lastGui, int pageNum) {
        this.mainGui = mainGui;
        this.viewer = mainGui.getViewer();
        this.restoreUser = mainGui.getRestoreUser();
        this.backupDataList = backupDataList;
        this.lastGui = lastGui;
        this.pageNum = pageNum;
        this.categoryGui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(StringUtils.format(AxInventoryRestore.MESSAGES.getString("guis.categorygui.title").replace("%player%", mainGui.getName()), new TagResolver[0]))).rows(this.rows)).pageSize(this.rows * 9 - 9).create();
    }

    public void open() {
        this.categoryGui.clearPageItems();
        CategoryGui cGui = this;
        int n = 1;
        for (BackupData backupData : this.backupDataList) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("%category%", AxInventoryRestore.MESSAGES.getString("categories." + backupData.getReason() + ".raw", backupData.getReason()));
            replacements.put("%date%", DateUtils.formatDate(backupData.getDate()));
            replacements.put("%location%", LocationUtils.serializeLocationReadable(backupData.getLocation()));
            replacements.put("%cause%", backupData.getCause() == null ? "---" : backupData.getCause());
            ItemStack it = ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("guis.categorygui.item"), replacements).get();
            it.setAmount(n);
            this.categoryGui.addItem(new GuiItem(it, event -> new PreviewGui(cGui, backupData, this.categoryGui, this.categoryGui.getCurrentPageNum()).open()));
            if (++n <= 64) continue;
            this.categoryGui.update();
            n = 1;
        }
        this.categoryGui.update();
        this.categoryGui.setItem(this.rows, 3, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.previous-page")).get(), event2 -> this.categoryGui.previous()));
        this.categoryGui.setItem(this.rows, 7, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.next-page")).get(), event2 -> this.categoryGui.next()));
        this.categoryGui.setDefaultClickAction(event -> event.setCancelled(true));
        this.categoryGui.setItem(this.rows, 5, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.back")).get(), event2 -> this.lastGui.open((HumanEntity)this.viewer, this.pageNum)));
        this.categoryGui.open((HumanEntity)this.viewer);
    }

    public Player getViewer() {
        return this.viewer;
    }

    public UUID getRestoreUser() {
        return this.restoreUser;
    }

    public PaginatedGui getCategoryGui() {
        return this.categoryGui;
    }

    public MainGui getMainGui() {
        return this.mainGui;
    }
}

