/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.events;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.api.events.InventoryBackupEvent;
import com.artillexstudios.axinventoryrestore.api.events.InventoryRestoreEvent;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.events.WebHooks;
import com.artillexstudios.axinventoryrestore.utils.DateUtils;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxirEvents {
    public static boolean callInventoryBackupEvent(@NotNull Player player, @NotNull String category, @Nullable String extraInfo) {
        InventoryBackupEvent inventoryBackupEvent = new InventoryBackupEvent(player, category, extraInfo);
        Bukkit.getPluginManager().callEvent((Event)inventoryBackupEvent);
        WebHooks.sendBackupWebHook(Map.of("%player%", player.getName(), "%category%", AxInventoryRestore.MESSAGES.getString("categories." + category + ".raw", category), "%extrainfo%", extraInfo == null ? "---" : extraInfo, "%location%", LocationUtils.serializeLocationReadable(player.getLocation()), "%date%", DateUtils.formatDate(System.currentTimeMillis())));
        return inventoryBackupEvent.isCancelled();
    }

    public static boolean callInventoryRestoreEvent(@NotNull Player restorer, @NotNull BackupData backupData) {
        InventoryRestoreEvent inventoryRestoreEvent = new InventoryRestoreEvent(restorer, backupData);
        Bukkit.getPluginManager().callEvent((Event)inventoryRestoreEvent);
        WebHooks.sendRestoreWebHook(Map.of("%restorer%", restorer.getName(), "%player%", Bukkit.getOfflinePlayer((UUID)backupData.getPlayerUUID()).getName(), "%category%", AxInventoryRestore.MESSAGES.getString("categories." + backupData.getReason() + ".raw", backupData.getReason()), "%extrainfo%", backupData.getCause() == null ? "---" : backupData.getCause(), "%location%", LocationUtils.serializeLocationReadable(backupData.getLocation()), "%date%", DateUtils.formatDate(backupData.getDate())));
        return inventoryRestoreEvent.isCancelled();
    }

    public static void callBackupExportEvent(@NotNull Player restorer, @NotNull BackupData backupData) {
        WebHooks.sendExportWebHook(Map.of("%restorer%", restorer.getName(), "%category%", AxInventoryRestore.MESSAGES.getString("categories." + backupData.getReason() + ".raw", backupData.getReason()), "%player%", Bukkit.getOfflinePlayer((UUID)backupData.getPlayerUUID()).getName(), "%extrainfo%", backupData.getCause() == null ? "---" : backupData.getCause(), "%location%", LocationUtils.serializeLocationReadable(backupData.getLocation()), "%date%", DateUtils.formatDate(backupData.getDate())));
    }
}

