/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.commands.subcommands;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.guis.MainGui;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.queue.Priority;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public enum View {
    INSTANCE;


    public void execute(Player sender, String player) {
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            UUID uuid = this.getUUID(sender, player);
            if (uuid == null) {
                return;
            }
            String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            Scheduler.get().runAt(sender.getLocation(), t -> new MainGui(uuid, sender, Optional.ofNullable(name).orElse(player)).open());
        }, Priority.HIGH);
    }

    @Nullable
    private UUID getUUID(Player sender, String value) {
        UUID uuid = this.tryParseUUID(value);
        if (uuid != null) {
            return uuid;
        }
        uuid = AxInventoryRestore.getDatabase().getUUID(value);
        if (uuid != null) {
            return uuid;
        }
        AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)sender, "errors.unknown-player", Map.of("%number%", "name not found"));
        return null;
    }

    @Nullable
    private UUID tryParseUUID(String value) {
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

