/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.backups;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.hooks.AxShulkersHook;
import com.artillexstudios.axinventoryrestore.hooks.HookManager;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axinventoryrestore.queue.Priority;
import com.artillexstudios.axinventoryrestore.utils.DateUtils;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BackupData {
    private final int id;
    private final UUID player;
    private final String reason;
    private final Location location;
    private final long date;
    private final String cause;
    private final int inventoryId;
    private volatile ItemStack[] items = null;

    public BackupData(int id, @NotNull UUID player, @NotNull String reason, @NotNull Location location, long date, String cause, int inventoryId) {
        this.id = id;
        this.player = player;
        this.reason = reason;
        this.location = location;
        this.date = date;
        this.cause = cause;
        this.inventoryId = inventoryId;
    }

    public int getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public CompletableFuture<ItemStack[]> getItems() {
        if (this.items != null) {
            return CompletableFuture.completedFuture(this.items);
        }
        CompletableFuture<ItemStack[]> future = new CompletableFuture<ItemStack[]>();
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            ItemStack[] items = AxInventoryRestore.getDatabase().getItemsFromBackup(this.inventoryId);
            AxShulkersHook hook = HookManager.getAxShulkersHook();
            if (hook == null) {
                future.complete(items);
                return;
            }
            ArrayList futures = new ArrayList();
            for (ItemStack item : items) {
                if (item == null || item.getType().isAir()) continue;
                CompletableFuture itemFuture = new CompletableFuture();
                Scheduler.get().run(task -> {
                    hook.clean(item);
                    itemFuture.complete(item);
                });
                futures.add(itemFuture);
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                this.items = items;
                future.complete(items);
            });
        }, Priority.HIGH);
        return future;
    }

    public long getDate() {
        return this.date;
    }

    public UUID getPlayerUUID() {
        return this.player;
    }

    public String getReason() {
        return this.reason;
    }

    public String getCause() {
        return this.cause;
    }

    public CompletableFuture<ArrayList<ItemStack>> getInShulkers(@NotNull String restorerName) {
        return this.getItems().thenApply(items -> {
            ArrayList<ItemStack> shulkerItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> itemsCopy = new ArrayList<ItemStack>(Arrays.asList(items));
            while (!itemsCopy.isEmpty()) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("%date%", DateUtils.formatDate(this.date));
                replacements.put("%location%", LocationUtils.serializeLocationReadable(this.location));
                replacements.put("%cause%", this.cause == null ? "---" : this.cause);
                replacements.put("%staff%", restorerName);
                replacements.put("%player-uuid%", this.player.toString());
                ItemStack shulkerIt = ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("restored-shulker"), replacements).get();
                BlockStateMeta im = (BlockStateMeta)shulkerIt.getItemMeta();
                ShulkerBox shulker = (ShulkerBox)im.getBlockState();
                Iterator iterator = itemsCopy.iterator();
                while (iterator.hasNext()) {
                    ItemStack it = (ItemStack)iterator.next();
                    if (it == null) {
                        iterator.remove();
                        continue;
                    }
                    if (shulker.getInventory().firstEmpty() == -1) break;
                    if (Tag.SHULKER_BOXES.isTagged((Keyed)it.getType())) {
                        shulkerItems.add(it);
                    } else {
                        shulker.getInventory().addItem(new ItemStack[]{it});
                    }
                    iterator.remove();
                }
                im.setBlockState((BlockState)shulker);
                shulkerIt.setItemMeta((ItemMeta)im);
                shulkerItems.add(shulkerIt);
            }
            return shulkerItems;
        });
    }
}

