/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.backups;

import com.artillexstudios.axinventoryrestore.backups.BackupData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Backup {
    private final ArrayList<BackupData> backupDataList;
    private final HashMap<String, List<BackupData>> deathsPerTypes = new HashMap();

    public Backup(ArrayList<BackupData> backupDataList) {
        this.backupDataList = backupDataList;
        this.calculate();
    }

    private void calculate() {
        for (BackupData backupData : this.backupDataList) {
            if (this.deathsPerTypes.containsKey(backupData.getReason())) {
                List<BackupData> newAr = this.deathsPerTypes.get(backupData.getReason());
                newAr.add(backupData);
                this.deathsPerTypes.put(backupData.getReason(), newAr);
                continue;
            }
            this.deathsPerTypes.put(backupData.getReason(), new ArrayList<BackupData>(List.of(backupData)));
        }
    }

    public ArrayList<BackupData> getBackupDataList() {
        return this.backupDataList;
    }

    public HashMap<String, List<BackupData>> getDeathsPerTypes() {
        return this.deathsPerTypes;
    }

    public List<BackupData> getDeathsByReason(@NotNull String saveReason) {
        if (saveReason.equals("ALL")) {
            return this.backupDataList;
        }
        return this.deathsPerTypes.get(saveReason);
    }
}

