/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import revxrsal.zapper.Dependency;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.classloader.IsolatedClassLoader;
import revxrsal.zapper.repository.MavenRepository;
import revxrsal.zapper.repository.Repository;

public class TransitiveDependencyHelper {
    private static final String TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS = TransitiveDependencyHelper.replaceWithDots("com{}alessiodp{}libby{}maven{}resolver{}TransitiveDependencyCollector");
    private static final String ARTIFACT_CLASS = TransitiveDependencyHelper.replaceWithDots("org{}eclipse{}aether{}artifact{}Artifact");
    private final Object transitiveDependencyCollectorObject;
    private final Method resolveTransitiveDependenciesMethod;
    private final Method artifactGetGroupIdMethod;
    private final Method artifactGetArtifactIdMethod;
    private final Method artifactGetVersionMethod;
    private final Method artifactGetBaseVersionMethod;
    private final Method artifactGetClassifierMethod;
    private final DependencyManager libraryManager;

    public TransitiveDependencyHelper(DependencyManager libraryManager, Path saveDirectory) {
        this.libraryManager = libraryManager;
        URL[] urls = new URL[1];
        Dependency d2 = new Dependency(TransitiveDependencyHelper.replaceWithDots("com{}alessiodp{}libby{}maven{}resolver"), "libby-maven-resolver", "1.0.1");
        File file = new File(saveDirectory.toFile(), String.format("%s.%s-%s.jar", d2.getGroupId(), d2.getArtifactId(), d2.getVersion()));
        if (!file.exists()) {
            d2.download(file, Repository.maven("https://repo.alessiodp.com/releases/"));
        }
        try {
            urls[0] = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        IsolatedClassLoader classLoader = new IsolatedClassLoader(urls);
        try {
            Class<?> transitiveDependencyCollectorClass = classLoader.loadClass(TRANSITIVE_DEPENDENCY_COLLECTOR_CLASS);
            Class<?> artifactClass = classLoader.loadClass(ARTIFACT_CLASS);
            Constructor<?> constructor = transitiveDependencyCollectorClass.getConstructor(Path.class);
            constructor.setAccessible(true);
            this.transitiveDependencyCollectorObject = constructor.newInstance(saveDirectory);
            this.resolveTransitiveDependenciesMethod = transitiveDependencyCollectorClass.getMethod("findTransitiveDependencies", String.class, String.class, String.class, String.class, Stream.class);
            this.resolveTransitiveDependenciesMethod.setAccessible(true);
            this.artifactGetGroupIdMethod = artifactClass.getMethod("getGroupId", new Class[0]);
            this.artifactGetArtifactIdMethod = artifactClass.getMethod("getArtifactId", new Class[0]);
            this.artifactGetVersionMethod = artifactClass.getMethod("getVersion", new Class[0]);
            this.artifactGetBaseVersionMethod = artifactClass.getMethod("getBaseVersion", new Class[0]);
            this.artifactGetClassifierMethod = artifactClass.getMethod("getClassifier", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Dependency> findTransitiveLibraries(Dependency library) {
        ArrayList<Dependency> transitiveLibraries = new ArrayList<Dependency>();
        Set<Repository> globalRepositories = this.libraryManager.repositories();
        if (globalRepositories.isEmpty()) {
            throw new IllegalArgumentException("No repositories have been added before resolving transitive dependencies");
        }
        Stream<String> repositories = globalRepositories.stream().map(r -> ((MavenRepository)r).getRepositoryURL());
        try {
            Collection resolvedArtifacts = (Collection)this.resolveTransitiveDependenciesMethod.invoke(this.transitiveDependencyCollectorObject, library.getGroupId(), library.getArtifactId(), library.getVersion(), library.getClassifier(), repositories);
            for (Object resolved : resolvedArtifacts) {
                Map.Entry resolvedEntry = (Map.Entry)resolved;
                Object artifact = resolvedEntry.getKey();
                String repository = (String)resolvedEntry.getValue();
                String groupId = (String)this.artifactGetGroupIdMethod.invoke(artifact, new Object[0]);
                String artifactId = (String)this.artifactGetArtifactIdMethod.invoke(artifact, new Object[0]);
                String baseVersion = (String)this.artifactGetBaseVersionMethod.invoke(artifact, new Object[0]);
                String classifier = (String)this.artifactGetClassifierMethod.invoke(artifact, new Object[0]);
                if (library.getGroupId().equals(groupId) && library.getArtifactId().equals(artifactId)) continue;
                Dependency dependency2 = new Dependency(groupId, artifactId, baseVersion, classifier);
                transitiveLibraries.add(dependency2);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableCollection(transitiveLibraries);
    }

    private static String replaceWithDots(String string) {
        return string.replace("{}", ".");
    }
}

