/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.listeners.impl;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.utils.BackupLimiter;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class JoinListener
implements Listener {
    public JoinListener() {
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.load(player);
            }
        });
    }

    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent event) {
        CompletableFuture future = new CompletableFuture();
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            this.load(event.getPlayer());
            future.complete(null);
        });
        if (!AxInventoryRestore.CONFIG.getBoolean("enabled-backups.join", true)) {
            return;
        }
        future.thenRun(() -> Scheduler.get().run(() -> {
            AxInventoryRestore.getDatabase().saveInventory(event.getPlayer(), "JOIN", null);
            BackupLimiter.tryLimit(event.getPlayer().getUniqueId(), "join", "JOIN");
        }));
    }

    public void load(Player player) {
        AxInventoryRestore.getDatabase().join(player);
        AxInventoryRestore.getDatabase().fetchRestoreRequests(player.getUniqueId());
    }
}

