/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper;

import com.artillexstudios.axinventoryrestore.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.caffeine.caffeine.cache.Cache;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.ServerWrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.WorldWrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.Wrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.WrapperMapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.featureflags.FeatureFlags;
import java.time.Duration;

public class WrapperRegistry {
    public static final WrapperMapper<ServerPlayerWrapper> SERVER_PLAYER = WrapperRegistry.cachingMapper("server_player", (Integer)FeatureFlags.SERVER_PLAYER_CACHE_SIZE.get());
    public static final WrapperMapper<ServerWrapper> SERVER = WrapperRegistry.mapper("server");
    public static final WrapperMapper<WorldWrapper> WORLD = WrapperRegistry.mapper("world");
    public static final WrapperMapper<WrappedItemStack> ITEM_STACK = WrapperRegistry.mapper("item_stack");

    public static <T extends Wrapper<?>> WrapperMapper<T> mapper(String id) {
        return NMSHandlers.getNmsHandler().mapper(id);
    }

    public static <T extends Wrapper<?>> WrapperMapper<T> cachingMapper(final String id, final int maximumSize) {
        return new WrapperMapper<T>(){
            final Cache<Object, T> mapperCache;
            final WrapperMapper<T> delegate;
            {
                this.mapperCache = Caffeine.newBuilder().weakKeys().maximumSize((long)maximumSize).expireAfterAccess(Duration.ofSeconds(30L)).build();
                this.delegate = WrapperRegistry.mapper(id);
            }

            @Override
            public T map(Object object) {
                return (Wrapper)this.mapperCache.get(object, this.delegate::map);
            }
        };
    }
}

