/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.nms;

import com.artillexstudios.axinventoryrestore.libs.axapi.AxPlugin;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.NMSHandler;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.Version;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;

public class NMSHandlers {
    private static NMSHandler nmsHandler;

    private static boolean init(AxPlugin plugin) {
        Version version = Version.getServerVersion();
        if (version == Version.UNKNOWN) {
            LogUtils.warn("Could not load plugin {} due to version mismatch! Found protocol version {} which is unsupported!", plugin.getName(), Version.getProtocolVersion());
            return false;
        }
        if (nmsHandler != null) {
            LogUtils.warn("NMS support has already been enabled!", new Object[0]);
            return false;
        }
        try {
            nmsHandler = (NMSHandler)Class.forName("com.artillexstudios.axinventoryrestore.libs.axapi.nms.%s.NMSHandler".formatted(version.getNMSVersion())).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            LogUtils.warn("Could not enable NMSHandler due to an internal exception while loading NMSHandler!", exception);
            return false;
        }
        return true;
    }

    public static NMSHandler getNmsHandler() {
        return nmsHandler;
    }

    public static class American {
        public static boolean initialize(AxPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }

    public static class British {
        public static boolean initialise(AxPlugin plugin) {
            return NMSHandlers.init(plugin);
        }
    }
}

