/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.database;

import com.artillexstudios.axinventoryrestore.database.impl.Base;
import com.artillexstudios.axinventoryrestore.database.impl.H2;
import com.artillexstudios.axinventoryrestore.database.impl.MySQL;
import com.artillexstudios.axinventoryrestore.database.impl.PostgreSQL;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import com.artillexstudios.axinventoryrestore.utils.SQLUtils;
import com.artillexstudios.axinventoryrestore.utils.SerializationUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class Converter2 {
    private final Base base;

    public Converter2(Base base) {
        this.base = base;
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Migrating database... Don't stop the server while it's running!", new TagResolver[0]));
        int success = 0;
        if (this.convertUsers()) {
            ++success;
        }
        if (this.convertBackups()) {
            ++success;
        }
        if (success == 2) {
            this.dropOldTables();
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FF00[AxInventoryRestore] Successful conversion!", new TagResolver[0]));
        } else {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxInventoryRestore] Something went wrong while converting!", new TagResolver[0]));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean convertUsers() {
        if (!SQLUtils.tableExists(this.base.getConnection(), "axinventoryrestore_uuids")) {
            return true;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converting users...", new TagResolver[0]));
        String sql = "SELECT * FROM axinventoryrestore_uuids;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block30: {
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axinventoryrestore_uuids;");
                try {
                    try (ResultSet rs = stmt.executeQuery();){
                        String sql2 = "INSERT INTO axir_users(uuid, name) VALUES (?,?);";
                        try (PreparedStatement stmt2 = conn.prepareStatement("INSERT INTO axir_users(uuid, name) VALUES (?,?);");){
                            int processed = 0;
                            while (rs.next()) {
                                stmt2.setString(1, rs.getString(1));
                                stmt2.setString(2, rs.getString(2));
                                if (processed % 100 == 0) {
                                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converted: " + processed, new TagResolver[0]));
                                    stmt2.executeBatch();
                                }
                                ++processed;
                                stmt2.addBatch();
                            }
                            stmt2.executeBatch();
                            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converted users!", new TagResolver[0]));
                        }
                    }
                    bl = true;
                    if (stmt == null) break block30;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean convertBackups() {
        if (!SQLUtils.tableExists(this.base.getConnection(), "axinventoryrestore_data")) {
            return true;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converting backups... This might take a while!", new TagResolver[0]));
        String sql = "SELECT * FROM axinventoryrestore_data;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block35: {
                PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axinventoryrestore_data;");
                try {
                    try (ResultSet rs = stmt.executeQuery();){
                        String sql2 = "INSERT INTO axir_backups(userId, reasonId, world, x, y, z, inventory, time, cause) VALUES (?,?,?,?,?,?,?,?,?);";
                        try (PreparedStatement stmt2 = conn.prepareStatement("INSERT INTO axir_backups(userId, reasonId, world, x, y, z, inventory, time, cause) VALUES (?,?,?,?,?,?,?,?,?);");){
                            int processed = 0;
                            while (rs.next()) {
                                UUID uuid = UUID.fromString(rs.getString(1));
                                this.createUser(uuid, Bukkit.getOfflinePlayer((UUID)uuid).getName());
                                Location location = LocationUtils.deserializeLocation(rs.getString(3));
                                Integer userId = this.base.getUserId(uuid);
                                if (userId == null) {
                                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Invalid UUID " + String.valueOf(uuid) + ", skipping!", new TagResolver[0]));
                                    continue;
                                }
                                Integer reasonId = this.base.getReasonId(rs.getString(2));
                                if (reasonId == null) {
                                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Invalid reason " + rs.getString(1) + ", skipping!", new TagResolver[0]));
                                    continue;
                                }
                                stmt2.setInt(1, userId);
                                stmt2.setInt(2, reasonId);
                                stmt2.setString(3, location.getWorld().getName());
                                stmt2.setInt(4, location.getBlockX());
                                stmt2.setInt(5, location.getBlockY());
                                stmt2.setInt(6, location.getBlockZ());
                                byte[] data = SerializationUtils.invToBits(this.getOldSaveById(rs.getInt(4))).readAllBytes();
                                if (data.length > 65535) {
                                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Data size " + data.length + " too large, skipping!", new TagResolver[0]));
                                    continue;
                                }
                                stmt2.setBytes(7, data);
                                stmt2.setLong(8, rs.getLong(5));
                                if (rs.getString(6) == null) {
                                    stmt2.setString(9, null);
                                } else {
                                    stmt2.setString(9, rs.getString(6).equals("---") ? null : rs.getString(6));
                                }
                                if (processed % 100 == 0) {
                                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converted: " + processed, new TagResolver[0]));
                                    stmt2.executeBatch();
                                }
                                ++processed;
                                stmt2.addBatch();
                            }
                            stmt2.executeBatch();
                            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converted backups!", new TagResolver[0]));
                        }
                    }
                    bl = true;
                    if (stmt == null) break block35;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack[] getOldSaveById(int id) {
        String sql = "SELECT * FROM axinventoryrestore_backups WHERE id = ?;";
        try (Connection conn = this.base.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM axinventoryrestore_backups WHERE id = ?;");){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                ItemStack[] itemStackArray = SerializationUtils.invFromBase64(rs.getString(2));
                return itemStackArray;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void dropOldTables() {
        PreparedStatement stmt;
        Connection conn2;
        String sql = "DROP TABLE axinventoryrestore_backups;";
        try {
            conn2 = this.base.getConnection();
            try {
                stmt = conn2.prepareStatement(sql);
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn2 != null) {
                    conn2.close();
                }
            }
        }
        catch (SQLException conn2) {
            // empty catch block
        }
        sql = "DROP TABLE axinventoryrestore_uuids;";
        try {
            conn2 = this.base.getConnection();
            try {
                stmt = conn2.prepareStatement(sql);
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn2 != null) {
                    conn2.close();
                }
            }
        }
        catch (SQLException conn3) {
            // empty catch block
        }
        sql = "DROP TABLE axinventoryrestore_data;";
        try {
            conn2 = this.base.getConnection();
            try {
                stmt = conn2.prepareStatement(sql);
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn2 != null) {
                    conn2.close();
                }
            }
        }
        catch (SQLException conn4) {
            // empty catch block
        }
        if (this.base instanceof PostgreSQL) {
            sql = "VACUUM;";
        } else if (this.base instanceof H2) {
            sql = "SHUTDOWN DEFRAG;";
        }
        if (this.base instanceof MySQL) {
            return;
        }
        try {
            conn2 = this.base.getConnection();
            try {
                stmt = conn2.prepareStatement(sql);
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn2 != null) {
                    conn2.close();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void createUser(UUID uuid, @Nullable String name) {
        String sql = "INSERT INTO axir_users(uuid, name) VALUES (?,?);";
        String n = name == null ? uuid.toString() : name;
        try (Connection conn = this.base.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_users(uuid, name) VALUES (?,?);");){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, n);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            String sql2 = "UPDATE axir_users SET name = ? WHERE uuid = ?;";
            try (Connection conn2 = this.base.getConnection();
                 PreparedStatement stmt2 = conn2.prepareStatement("UPDATE axir_users SET name = ? WHERE uuid = ?;");){
                stmt2.setString(1, n);
                stmt2.setString(2, uuid.toString());
                stmt2.executeUpdate();
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

