/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore;

import com.artillexstudios.axinventoryrestore.commands.CommandManager;
import com.artillexstudios.axinventoryrestore.database.Database;
import com.artillexstudios.axinventoryrestore.database.impl.H2;
import com.artillexstudios.axinventoryrestore.database.impl.MySQL;
import com.artillexstudios.axinventoryrestore.database.impl.PostgreSQL;
import com.artillexstudios.axinventoryrestore.discord.DiscordAddon;
import com.artillexstudios.axinventoryrestore.events.WebHooks;
import com.artillexstudios.axinventoryrestore.hooks.HookManager;
import com.artillexstudios.axinventoryrestore.libraries.Libraries;
import com.artillexstudios.axinventoryrestore.libs.axapi.AxPlugin;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.Config;
import com.artillexstudios.axinventoryrestore.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axinventoryrestore.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axinventoryrestore.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axinventoryrestore.libs.bstats.charts.SimplePie;
import com.artillexstudios.axinventoryrestore.listeners.ListenerManager;
import com.artillexstudios.axinventoryrestore.queue.PriorityThreadedQueue;
import com.artillexstudios.axinventoryrestore.schedulers.AutoBackupScheduler;
import com.artillexstudios.axinventoryrestore.utils.UpdateNotifier;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.relocation.Relocation;

public final class AxInventoryRestore
extends AxPlugin {
    public static Config CONFIG;
    public static Config MESSAGES;
    public static Config DISCORD;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static PriorityThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    private static DiscordAddon discordAddon;
    private static AxMetrics metrics;
    private static boolean debug;

    @Nullable
    public static DiscordAddon getDiscordAddon() {
        return discordAddon;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Database getDatabase() {
        return database;
    }

    public static PriorityThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static boolean isDebugMode() {
        return debug;
    }

    public static void setDebugMode(boolean debug) {
        AxInventoryRestore.debug = debug;
    }

    @Override
    public void dependencies(DependencyManagerWrapper manager) {
        instance = this;
        manager.repository("https://jitpack.io/");
        manager.repository("https://repo.codemc.org/repository/maven-public/");
        manager.repository("https://repo.papermc.io/repository/maven-public/");
        manager.repository("https://repo.artillex-studios.com/releases/");
        DependencyManager dependencyManager = manager.wrapped();
        for (Libraries lib : Libraries.values()) {
            dependencyManager.dependency(lib.fetchLibrary());
            for (Relocation relocation : lib.relocations()) {
                dependencyManager.relocate(relocation);
            }
        }
    }

    @Override
    public void enable() {
        Metrics bstats = new Metrics((Plugin)this, 19446);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        MESSAGES = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        DISCORD = new Config(new File(this.getDataFolder(), "discord.yml"), this.getResource("discord.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        WebHooks.reload();
        threadedQueue = new PriorityThreadedQueue("AxInventoryRestore-Datastore-thread");
        debug = CONFIG.getBoolean("debug", false);
        MESSAGEUTILS = new MessageUtils(MESSAGES.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "mysql": {
                database = new MySQL();
                break;
            }
            case "postgresql": {
                database = new PostgreSQL();
                break;
            }
            default: {
                database = new H2();
            }
        }
        bstats.addCustomChart(new SimplePie("database_type", () -> database.getType()));
        database.setup();
        AxInventoryRestore.getThreadedQueue().submit(() -> database.cleanup());
        HookManager.setupHooks();
        CommandManager.load();
        AutoBackupScheduler.start();
        ListenerManager.register();
        boolean loadDiscordAddon = CONFIG.getBoolean("enable-discord-addon", false);
        if (loadDiscordAddon && !DISCORD.getString("token").isBlank()) {
            discordAddon = new DiscordAddon();
        }
        bstats.addCustomChart(new SimplePie("uses_discord_addon", () -> "" + loadDiscordAddon));
        metrics = new AxMetrics(this, 19L);
        metrics.start();
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 4610);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        AutoBackupScheduler.stop();
        threadedQueue.stop();
        database.disable();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
    }

    static {
        discordAddon = null;
    }
}

