/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.utils;

import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.YamlDocument;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    private final YamlDocument config;
    private final YamlDocument prefixConfig;
    private final String prefixRoute;

    public MessageUtils(YamlDocument config, String prefixRoute) {
        this.config = config;
        this.prefixConfig = config;
        this.prefixRoute = prefixRoute;
    }

    public MessageUtils(YamlDocument config, String prefixRoute, YamlDocument prefixConfig) {
        this.config = config;
        this.prefixConfig = prefixConfig;
        this.prefixRoute = prefixRoute;
    }

    public static void sendMessage(CommandSender sender, String message, TagResolver ... resolvers) {
        MessageUtils.sendMessage(sender, "", message, resolvers);
    }

    public static void sendMessage(CommandSender sender, String prefix, String message, TagResolver ... resolvers) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.message(StringUtils.format(prefix + message, resolvers));
        } else {
            sender.sendMessage(StringUtils.formatToString(prefix + message, resolvers));
        }
    }

    public void sendFormatted(CommandSender sender, String message, TagResolver ... resolvers) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.message(StringUtils.format(message, resolvers));
        } else {
            sender.sendMessage(StringUtils.formatToString(message, resolvers));
        }
    }

    public void sendLang(CommandSender commandSender, String message, TagResolver ... resolvers) {
        String configString = this.config.getString(message);
        if (configString == null || configString.isEmpty()) {
            return;
        }
        this.sendFormatted(commandSender, this.prefixConfig.getString(this.prefixRoute) + configString, resolvers);
    }

    public void sendFormatted(CommandSender sender, String message, Map<String, String> replacements) {
        AtomicReference<String> toFormat = new AtomicReference<String>(message);
        replacements.forEach((pattern, replacement) -> toFormat.set(((String)toFormat.get()).replace((CharSequence)pattern, (CharSequence)replacement)));
        this.sendFormatted(sender, toFormat.get(), new TagResolver[0]);
    }

    public void sendLang(CommandSender sender, String message, Map<String, String> replacements) {
        String parsed = this.config.getString(message);
        if (parsed == null || parsed.isEmpty()) {
            return;
        }
        this.sendFormatted(sender, this.prefixConfig.getString(this.prefixRoute) + parsed, replacements);
    }
}

