/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.guis;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.discord.DiscordAddon;
import com.artillexstudios.axinventoryrestore.events.AxirEvents;
import com.artillexstudios.axinventoryrestore.guis.CategoryGui;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axinventoryrestore.libs.gui.builder.gui.ChestGuiBuilder;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.Gui;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.GuiItem;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.PaginatedGui;
import com.artillexstudios.axinventoryrestore.utils.LocationUtils;
import com.artillexstudios.axinventoryrestore.utils.PermissionUtils;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PreviewGui {
    private final Gui previewGui;
    private final CategoryGui categoryGui;
    private final Player viewer;
    private final UUID restoreUser;
    private final BackupData backupData;
    private final PaginatedGui lastGui;
    private final int pageNum;

    public PreviewGui(@NotNull CategoryGui categoryGui, BackupData backupData, PaginatedGui lastGui, int pageNum) {
        this.categoryGui = categoryGui;
        this.viewer = categoryGui.getViewer();
        this.restoreUser = categoryGui.getRestoreUser();
        this.backupData = backupData;
        this.lastGui = lastGui;
        this.pageNum = pageNum;
        this.previewGui = ((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().title(StringUtils.format(AxInventoryRestore.MESSAGES.getString("guis.previewgui.title").replace("%player%", categoryGui.getMainGui().getName()), new TagResolver[0]))).rows(6)).create();
    }

    public void open() {
        long time = System.currentTimeMillis();
        if (AxInventoryRestore.isDebugMode()) {
            LogUtils.debug("Opening backup preview for {}", (Object)this.viewer.getName());
        }
        this.backupData.getItems().thenAccept(items -> {
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("Preview data loaded for {} in {}ms", (Object)this.viewer.getName(), (Object)(System.currentTimeMillis() - time));
            }
            int n = -1;
            for (ItemStack it : items) {
                ++n;
                if (it == null || it.getType().isAir()) continue;
                this.previewGui.setItem(n, new GuiItem(it, event -> {
                    if (!PermissionUtils.hasPermission(this.viewer, "modify")) {
                        event.setCancelled(true);
                        return;
                    }
                    event.setCurrentItem(it);
                }));
            }
            int starter = 46;
            DiscordAddon discordAddon = AxInventoryRestore.getDiscordAddon();
            if (discordAddon != null) {
                starter = 45;
            }
            this.previewGui.setItem(starter, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.back")).get(), event -> {
                this.lastGui.open((HumanEntity)this.viewer, this.pageNum);
                event.setCancelled(true);
            }));
            this.previewGui.setItem(starter + 2, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("guis.previewgui.teleport"), Map.of("%location%", LocationUtils.serializeLocationReadable(this.backupData.getLocation()))).get(), event -> {
                event.setCancelled(true);
                if (!PermissionUtils.hasPermission(this.viewer, "teleport")) {
                    AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.no-permission", new TagResolver[0]);
                    return;
                }
                PaperUtils.teleportAsync((Entity)this.viewer, this.backupData.getLocation());
                this.viewer.closeInventory();
            }));
            boolean isEnder = this.backupData.getReason().equals("ENDER_CHEST");
            this.previewGui.setItem(starter + 4, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("guis.previewgui.quick-restore" + (isEnder ? "-ender-chest" : ""))).get(), event -> {
                event.setCancelled(true);
                if (!PermissionUtils.hasPermission(this.viewer, "restore")) {
                    AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.no-permission", new TagResolver[0]);
                    return;
                }
                Player player = Bukkit.getPlayer((UUID)this.restoreUser);
                if (player == null) {
                    AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.player-offline", new TagResolver[0]);
                    return;
                }
                if (AxirEvents.callInventoryRestoreEvent(this.viewer, this.backupData)) {
                    return;
                }
                int n2 = 0;
                for (ItemStack it : items) {
                    if (it == null) {
                        it = new ItemStack(Material.AIR);
                    }
                    if (isEnder) {
                        player.getEnderChest().setItem(n2, it);
                    } else {
                        player.getInventory().setItem(n2, it);
                    }
                    ++n2;
                }
            }));
            int starterFinal = starter;
            this.backupData.getInShulkers(this.viewer.getName()).thenAccept(item -> {
                this.previewGui.setItem(starterFinal + 6, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("guis.previewgui.export-as-shulker"), Map.of("%shulker-amount%", Integer.toString(item.size()))).get(), event -> {
                    event.setCancelled(true);
                    if (!PermissionUtils.hasPermission(this.viewer, "export")) {
                        AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.no-permission", new TagResolver[0]);
                        return;
                    }
                    AxirEvents.callBackupExportEvent(this.viewer, this.backupData);
                    for (ItemStack i : item) {
                        this.viewer.getInventory().addItem(new ItemStack[]{i});
                    }
                }));
                this.previewGui.update();
            });
            if (discordAddon != null) {
                this.previewGui.setItem(starter + 8, new GuiItem(discordAddon.getRequestItem(), event -> {
                    event.setCancelled(true);
                    if (!PermissionUtils.hasPermission(this.viewer, "discord-request")) {
                        AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.no-permission", new TagResolver[0]);
                        return;
                    }
                    discordAddon.sendRequest((Player)event.getWhoClicked(), this.backupData);
                }));
            }
            this.previewGui.update();
        });
        this.previewGui.open((HumanEntity)this.viewer);
        if (AxInventoryRestore.isDebugMode()) {
            LogUtils.debug("Preview gui opened for {} in {}ms", (Object)this.viewer.getName(), (Object)(System.currentTimeMillis() - time));
        }
    }
}

