/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.queue;

import com.artillexstudios.axinventoryrestore.queue.Priority;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PriorityThreadedQueue<T extends Runnable>
implements Runnable,
Executor {
    private static final Logger log = LoggerFactory.getLogger(PriorityThreadedQueue.class);
    private final ArrayDeque<T> jobs = Queues.newArrayDeque();
    private final Thread thread;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean killed = false;

    public PriorityThreadedQueue(String threadName) {
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.start();
    }

    public void stop() {
        this.killed = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void submit(T task) {
        this.submit(task, Priority.LOW);
    }

    public void submit(T task, Priority priority) {
        this.lock.lock();
        try {
            if (priority == Priority.LOW) {
                this.jobs.offer(task);
            } else if (priority == Priority.HIGH) {
                this.jobs.offerFirst(task);
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        while (!this.killed) {
            try {
                T next = this.next();
                if (next == null) continue;
                next.run();
            }
            catch (Exception exception) {
                log.error("An unexpected error occurred while running ThreadedQueue {}!", (Object)this.thread.getName(), (Object)exception);
            }
        }
    }

    public T next() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.jobs.isEmpty() && !this.killed) {
                this.condition.await();
            }
            if (this.jobs.isEmpty()) {
                T t = null;
                return t;
            }
            Runnable runnable = (Runnable)this.jobs.remove();
            return (T)runnable;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.submit(command);
    }
}

