/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.listeners.impl;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.utils.BackupLimiter;
import java.util.concurrent.CompletableFuture;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class JoinListener
implements Listener {
    @EventHandler
    public void onJoin(@NotNull PlayerJoinEvent event) {
        if (!AxInventoryRestore.CONFIG.getBoolean("enabled-backups.join", true)) {
            return;
        }
        CompletableFuture future = new CompletableFuture();
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            AxInventoryRestore.getDatabase().join(event.getPlayer());
            AxInventoryRestore.getDatabase().fetchRestoreRequests(event.getPlayer().getUniqueId());
            future.complete(null);
        });
        future.thenRun(() -> Scheduler.get().run(() -> {
            AxInventoryRestore.getDatabase().saveInventory(event.getPlayer(), "JOIN", null);
            BackupLimiter.tryLimit(event.getPlayer().getUniqueId(), "join", "JOIN");
        }));
    }
}

