/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.hologram.page;

import com.artillexstudios.axinventoryrestore.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axinventoryrestore.libs.axapi.hologram.Hologram;
import com.artillexstudios.axinventoryrestore.libs.axapi.hologram.HologramType;
import com.artillexstudios.axinventoryrestore.libs.axapi.hologram.HologramTypes;
import com.artillexstudios.axinventoryrestore.libs.axapi.hologram.Holograms;
import com.artillexstudios.axinventoryrestore.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axinventoryrestore.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axinventoryrestore.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axinventoryrestore.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axinventoryrestore.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axinventoryrestore.libs.axapi.packetentity.meta.entity.ItemEntityMeta;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class DroppedItemHologramPage
extends HologramPage<WrappedItemStack, HologramType<WrappedItemStack>> {
    private final PacketEntity droppedItem = NMSHandlers.getNmsHandler().createEntity(EntityType.DROPPED_ITEM, this.getLocation());
    private WrappedItemStack content;
    private boolean spawned = false;

    public DroppedItemHologramPage(Hologram hologram, boolean firstPage, Location location) {
        super(hologram, firstPage, location);
    }

    @Override
    public void setContent(WrappedItemStack content) {
        this.content = content;
        this.create();
    }

    private void create() {
        ItemEntityMeta meta = (ItemEntityMeta)this.droppedItem.meta();
        meta.itemStack(this.content);
        meta.hasNoGravity(true);
        if (this.getEntityMetaHandler() != null) {
            this.getEntityMetaHandler().accept(meta);
        }
        if (!this.isFirstPage()) {
            this.droppedItem.setVisibleByDefault(false);
        }
        this.droppedItem.onInteract(event -> {
            if (this.getClickHandler() != null) {
                this.getClickHandler().accept((PacketEntityInteractEvent)((Object)event));
            }
            this.getHologram().changePage(event.getPlayer(), event.isAttack() ? Hologram.PageChangeDirection.BACK : Hologram.PageChangeDirection.FORWARD);
        });
    }

    @Override
    public WrappedItemStack getContent() {
        return this.content;
    }

    @Override
    public HologramType<WrappedItemStack> getType() {
        return HologramTypes.ITEM_STACK;
    }

    @Override
    public boolean containsPlaceholders() {
        return false;
    }

    @Override
    public boolean contentEquals(HologramPage<?, ?> other) {
        if (!(other instanceof DroppedItemHologramPage)) {
            return false;
        }
        DroppedItemHologramPage droppedItemPage = (DroppedItemHologramPage)other;
        return droppedItemPage.getContent().equals(this.getContent());
    }

    @Override
    public void hide(Player player) {
        this.droppedItem.hide(player);
    }

    @Override
    public void show(Player player) {
        this.droppedItem.show(player);
    }

    @Override
    public void teleport(Location location) {
        this.setLocation(location);
        if (this.droppedItem == null) {
            return;
        }
        this.droppedItem.teleport(location);
    }

    @Override
    public void remove() {
        if (this.droppedItem == null) {
            return;
        }
        this.spawned = false;
        Holograms.remove(this.droppedItem.id());
        this.droppedItem.remove();
    }

    @Override
    public void update() {
        if (this.droppedItem == null) {
            return;
        }
        this.droppedItem.update();
    }

    @Override
    public EntityMeta getEntityMeta() {
        return this.droppedItem.meta();
    }

    @Override
    public synchronized boolean spawn() {
        if (this.spawned) {
            return false;
        }
        Holograms.put(this.droppedItem.id(), this);
        this.droppedItem.spawn();
        this.spawned = true;
        return true;
    }
}

