/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.database.impl;

import com.artillexstudios.axinventoryrestore.libs.axapi.AxPlugin;
import com.artillexstudios.axinventoryrestore.libs.axapi.database.DatabaseConfig;
import com.artillexstudios.axinventoryrestore.libs.axapi.database.DatabaseType;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.hikari.HikariConfig;
import java.util.List;
import java.util.UUID;

public class SQLiteDatabaseType
extends DatabaseType {
    private final String relocated;

    public SQLiteDatabaseType() {
        this("org.sqlite");
    }

    public SQLiteDatabaseType(String relocated) {
        this.relocated = relocated;
        this.registerTransformer(UUID.class, uuid -> List.of(uuid.toString()));
    }

    @Override
    public HikariConfig config(DatabaseConfig databaseConfig) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.relocated + ".JDBC");
        config.setJdbcUrl((String)(databaseConfig.url == null ? "jdbc:sqlite:" + String.valueOf(((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).getDataFolder()) + "/data" : databaseConfig.url));
        config.setMaximumPoolSize(databaseConfig.pool.maximumPoolSize);
        config.setMinimumIdle(databaseConfig.pool.minimumIdle);
        return config;
    }

    @Override
    public String name() {
        return "sqlite";
    }
}

