/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.config.reader;

import com.artillexstudios.axinventoryrestore.libs.axapi.config.YamlConstructor;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.adapters.TypeAdapterHolder;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.AutoGeneratedComment;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.Comment;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.ConfigurationPart;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.Hidden;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.Ignored;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.Named;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.PostProcess;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.annotation.Serializable;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.reader.Handler;
import com.artillexstudios.axinventoryrestore.libs.axapi.config.renamer.KeyRenamer;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.DumperOptions;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.Yaml;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.comments.CommentLine;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.comments.CommentType;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.nodes.AnchorNode;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.nodes.MappingNode;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.nodes.Node;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.nodes.NodeTuple;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.snakeyaml.nodes.Tag;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.UncheckedUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ClassConfigurationReader
implements Handler {
    private final TypeAdapterHolder holder;
    private final YamlConstructor constructor;
    private final KeyRenamer renamer;
    private final Class<?> clazz;
    private final Yaml yaml;

    public ClassConfigurationReader(Yaml yaml, YamlConstructor constructor, TypeAdapterHolder holder, KeyRenamer renamer, Class<?> clazz) {
        this.holder = holder;
        this.constructor = constructor;
        this.renamer = renamer;
        this.clazz = clazz;
        this.yaml = yaml;
    }

    @Override
    public Pair<Map<String, Object>, Map<String, Comment>> read(InputStream stream, Object instance) {
        Map map = (Map)this.yaml.load(stream);
        LinkedHashMap<String, Object> ordered = new LinkedHashMap<String, Object>();
        HashMap<String, Comment> comments = new HashMap<String, Comment>();
        map = map == null ? new HashMap() : map;
        try {
            this.readClass(map, ordered, this.clazz, instance);
            this.readComments("", comments, this.clazz);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Pair.of(ordered, comments);
    }

    @Override
    public String write(Map<String, Object> contents, Map<String, Comment> comments) {
        StringWriter writer = new StringWriter();
        MappingNode node = this.map(contents);
        this.writeComments("", comments, node);
        this.yaml.serialize(node, writer);
        return writer.toString();
    }

    private MappingNode map(Map<String, Object> map) {
        ArrayList<NodeTuple> nodes = new ArrayList<NodeTuple>();
        if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Mapping: {}", map);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Node value;
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.debug("Mapping entry: {}", entry);
            }
            Node key = this.yaml.represent(entry.getKey());
            Object object = entry.getValue();
            if (object instanceof Map) {
                Map m = (Map)object;
                value = this.map((Map)UncheckedUtils.unsafeCast(m));
            } else {
                value = this.yaml.represent(this.holder.serialize(entry.getValue(), entry.getValue().getClass()));
            }
            nodes.add(new NodeTuple(key, value));
        }
        return new MappingNode(Tag.MAP, nodes, DumperOptions.FlowStyle.BLOCK);
    }

    private void writeComments(String path, Map<String, Comment> comments, MappingNode node) {
        for (NodeTuple nodeTuple : node.getValue()) {
            String[] split;
            String path1;
            Node key = nodeTuple.getKeyNode();
            String keyString = String.valueOf(this.constructor.construct(key));
            Node value = nodeTuple.getValueNode();
            while (value instanceof AnchorNode) {
                AnchorNode anchorNode = (AnchorNode)value;
                value = anchorNode.getRealNode();
            }
            String string = path1 = path.isEmpty() ? keyString : path + "." + keyString;
            if (value instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)value;
                this.writeComments(path1, comments, mappingNode);
                continue;
            }
            Comment comment = comments.get(path1);
            if (comment == null) continue;
            ArrayList<CommentLine> lines = new ArrayList<CommentLine>();
            for (String string2 : split = comment.value().split("\n")) {
                lines.add(new CommentLine(null, null, string2, comment.type() == Comment.CommentType.BLOCK ? CommentType.BLOCK : CommentType.IN_LINE));
            }
            if (comment.type() == Comment.CommentType.BLOCK) {
                key.setBlockComments(lines);
                continue;
            }
            key.setInLineComments(lines);
        }
    }

    private void readComments(String path, Map<String, Comment> comments, Class<?> clazz) {
        Named named;
        for (Field field : clazz.getFields()) {
            Class cl;
            AutoGeneratedComment autoGeneratedComment;
            String path1;
            if (Modifier.isFinal(field.getModifiers()) || clazz.isAnnotationPresent(Ignored.class)) continue;
            named = field.getAnnotation(Named.class);
            final Type type = field.getGenericType();
            String name = named != null ? named.value() : this.renamer.rename(field.getName());
            Comment comment = field.getAnnotation(Comment.class);
            String string = path1 = path.isEmpty() ? name : path + "." + name;
            if (comment != null) {
                comments.put(path1, comment);
            }
            if ((autoGeneratedComment = field.getAnnotation(AutoGeneratedComment.class)) != null) {
                comments.put(path1, new Comment(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return Comment.class;
                    }

                    @Override
                    public String value() {
                        return autoGeneratedComment.value() + String.join((CharSequence)", ", ClassConfigurationReader.this.holder.adapter(null, type).values(type));
                    }

                    @Override
                    public Comment.CommentType type() {
                        return Comment.CommentType.BLOCK;
                    }
                });
            }
            if (!(type instanceof Class) || !(cl = (Class)type).isAnnotationPresent(Serializable.class)) continue;
            this.readComments(path1, comments, cl);
        }
        for (AnnotatedElement annotatedElement : clazz.getClasses()) {
            String key;
            if (((Class)annotatedElement).isAnnotationPresent(Ignored.class) || ((Class)annotatedElement).isAnnotationPresent(Serializable.class) || ConfigurationPart.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
            named = ((Class)annotatedElement).getAnnotation(Named.class);
            String name = named == null ? this.renamer.rename(((Class)annotatedElement).getSimpleName()) : named.value();
            Comment comment = ((Class)annotatedElement).getAnnotation(Comment.class);
            String string = key = path.isEmpty() ? name : path + "." + name;
            if (comment != null) {
                comments.put(key, comment);
            }
            this.readComments(key, comments, (Class<?>)annotatedElement);
        }
    }

    private void readClass(Map<String, Object> from, LinkedHashMap<String, Object> to, Class<?> clazz, Object instance) throws IllegalAccessException {
        Named named;
        for (Field field : clazz.getFields()) {
            if (Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(Ignored.class)) continue;
            named = field.getAnnotation(Named.class);
            Type type = field.getGenericType();
            String name = named != null ? named.value() : this.renamer.rename(field.getName());
            Object found = from.get(name);
            if (found == null) {
                if (field.isAnnotationPresent(Hidden.class)) continue;
                found = field.get(instance);
            } else {
                found = this.holder.deserialize(found, type);
            }
            to.put(name, found);
            field.set(instance, found);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(PostProcess.class)) continue;
            try {
                ((Method)accessibleObject).invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        for (AnnotatedElement annotatedElement : clazz.getClasses()) {
            if (((Class)annotatedElement).isAnnotationPresent(Ignored.class) || ((Class)annotatedElement).isAnnotationPresent(Serializable.class) || ConfigurationPart.class.isAssignableFrom((Class<?>)annotatedElement)) continue;
            named = ((Class)annotatedElement).getAnnotation(Named.class);
            String name = named == null ? this.renamer.rename(((Class)annotatedElement).getSimpleName()) : named.value();
            Map newContents = (Map)UncheckedUtils.unsafeCast(from.getOrDefault(name, new LinkedHashMap()));
            to.put(name, newContents);
            this.readClass(newContents, to, (Class<?>)annotatedElement, instance);
        }
    }
}

