/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.collections;

import com.artillexstudios.axinventoryrestore.libs.axapi.utils.UncheckedUtils;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IdentityArrayMap<K, V>
implements Map<K, V> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] keys;
    private Object[] values;
    private int size;

    public IdentityArrayMap() {
        this.keys = EMPTY_ARRAY;
        this.values = EMPTY_ARRAY;
    }

    public IdentityArrayMap(int size) {
        this.keys = new Object[size];
        this.values = new Object[size];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKey(key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] values = this.values;
        int i = this.size;
        while (values[i] != value) {
            if (i-- != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        int index = this.findKey(key);
        return index == -1 ? null : (V)UncheckedUtils.unsafeCast(this.values[index]);
    }

    @Override
    public V put(K key, V value) {
        int previousPos = this.findKey(key);
        if (previousPos != -1) {
            Object previous = UncheckedUtils.unsafeCast(this.values[previousPos]);
            this.values[previousPos] = value;
            return (V)previous;
        }
        if (this.size == this.keys.length) {
            Object[] newKeys = new Object[this.size == 0 ? 2 : this.size * 2];
            Object[] newValues = new Object[this.size == 0 ? 2 : this.size * 2];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.keys = newKeys;
            this.values = newValues;
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
        return null;
    }

    @Override
    public V remove(Object key) {
        int previousPos = this.findKey(key);
        if (previousPos == -1) {
            return null;
        }
        Object oldValue = UncheckedUtils.unsafeCast(this.values[previousPos]);
        int tail = this.size - previousPos - 1;
        System.arraycopy(this.keys, previousPos + 1, this.keys, previousPos, tail);
        System.arraycopy(this.values, previousPos + 1, this.values, previousPos, tail);
        --this.size;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        return (V)oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            @NotNull
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < IdentityArrayMap.this.size;
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int previousIndex = this.index++;
                        return UncheckedUtils.unsafeCast(IdentityArrayMap.this.keys[previousIndex]);
                    }
                };
            }

            @Override
            public int size() {
                return IdentityArrayMap.this.size;
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < IdentityArrayMap.this.size;
                    }

                    @Override
                    public V next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int previousIndex = this.index++;
                        return UncheckedUtils.unsafeCast(IdentityArrayMap.this.values[previousIndex]);
                    }
                };
            }

            @Override
            public int size() {
                return IdentityArrayMap.this.size;
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < IdentityArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new Map.Entry<K, V>(){
                            private final int currentIndex;
                            {
                                this.currentIndex = index++;
                            }

                            @Override
                            public K getKey() {
                                return UncheckedUtils.unsafeCast(IdentityArrayMap.this.keys[this.currentIndex]);
                            }

                            @Override
                            public V getValue() {
                                return UncheckedUtils.unsafeCast(IdentityArrayMap.this.values[this.currentIndex]);
                            }

                            @Override
                            public V setValue(V value) {
                                Object old = UncheckedUtils.unsafeCast(IdentityArrayMap.this.values[this.currentIndex]);
                                IdentityArrayMap.this.values[this.currentIndex] = value;
                                return old;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        if (this.index < 0) {
                            throw new IllegalStateException();
                        }
                        IdentityArrayMap.this.remove(IdentityArrayMap.this.keys[this.index - 1]);
                        --this.index;
                    }
                };
            }

            @Override
            public int size() {
                return IdentityArrayMap.this.size;
            }
        };
    }

    private int findKey(Object key) {
        int i = this.size;
        Object[] keys = this.keys;
        if (i == keys.length) {
            return -1;
        }
        while (keys[i] != key) {
            if (i-- != 0) continue;
            return -1;
        }
        return i;
    }
}

