/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.guis;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.backups.Backup;
import com.artillexstudios.axinventoryrestore.backups.BackupData;
import com.artillexstudios.axinventoryrestore.guis.CategoryGui;
import com.artillexstudios.axinventoryrestore.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axinventoryrestore.libs.gui.builder.gui.PaginatedBuilder;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.Gui;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.GuiItem;
import com.artillexstudios.axinventoryrestore.libs.gui.guis.PaginatedGui;
import com.artillexstudios.axinventoryrestore.queue.Priority;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MainGui {
    private final PaginatedGui mainGui;
    private final Player viewer;
    private final UUID restoreUser;
    private final String name;
    private final int rows = AxInventoryRestore.CONFIG.getInt("menu-rows.main-menu", 4);

    public MainGui(@NotNull UUID restoreUser, @NotNull Player viewer, String name) {
        this.viewer = viewer;
        this.restoreUser = restoreUser;
        this.name = name;
        this.mainGui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(StringUtils.format(AxInventoryRestore.MESSAGES.getString("guis.maingui.title").replace("%player%", name), new TagResolver[0]))).rows(this.rows)).pageSize(this.rows * 9 - 9).create();
    }

    public void open() {
        this.mainGui.clearPageItems();
        long time = System.currentTimeMillis();
        if (AxInventoryRestore.isDebugMode()) {
            LogUtils.debug("Opening gui for {}", (Object)this.viewer.getName());
        }
        AxInventoryRestore.getThreadedQueue().submit(() -> {
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("ThreadedQueue submit for {} in {}ms", (Object)this.viewer.getName(), (Object)(System.currentTimeMillis() - time));
            }
            Backup backup = AxInventoryRestore.getDatabase().getBackupsOfPlayer(this.restoreUser);
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("getBackupsOfPlayer for {} in {}ms", (Object)this.viewer.getName(), (Object)(System.currentTimeMillis() - time));
            }
            ArrayList<String> reasons = new ArrayList<String>();
            if (AxInventoryRestore.CONFIG.getBoolean("enable-all-category")) {
                reasons.add("ALL");
            }
            reasons.addAll(backup.getDeathsPerTypes().keySet());
            if (AxInventoryRestore.CONFIG.getBoolean("enable-all-category") && reasons.size() == 1 || reasons.isEmpty()) {
                AxInventoryRestore.MESSAGEUTILS.sendLang((CommandSender)this.viewer, "errors.unknown-player", Map.of("%number%", "3"));
                Scheduler.get().runAt(this.viewer.getLocation(), t -> this.viewer.closeInventory());
                return;
            }
            for (String saveReason : reasons) {
                ItemStack item = ItemBuilder.create(Material.PAPER).setName(StringUtils.formatToString("<!i>&#FFFF00&l" + saveReason, new TagResolver[0])).get();
                List<BackupData> backupDataList = backup.getDeathsByReason(saveReason);
                if (AxInventoryRestore.MESSAGES.getSection("categories." + saveReason) != null) {
                    item = ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("categories." + saveReason), Map.of("%amount%", "" + backupDataList.size())).get();
                }
                this.mainGui.addItem(new GuiItem(item, event -> Scheduler.get().run(task -> new CategoryGui(this, backupDataList, this.mainGui, this.mainGui.getCurrentPageNum()).open())));
            }
            this.mainGui.update();
            if (AxInventoryRestore.isDebugMode()) {
                LogUtils.debug("Opened gui for {} in {}ms", (Object)this.viewer.getName(), (Object)(System.currentTimeMillis() - time));
            }
        }, Priority.HIGH);
        this.mainGui.setItem(this.rows, 3, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.previous-page")).get(), event2 -> this.mainGui.previous()));
        this.mainGui.setItem(this.rows, 7, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.next-page")).get(), event2 -> this.mainGui.next()));
        this.mainGui.setDefaultClickAction(event -> event.setCancelled(true));
        this.mainGui.setItem(this.rows, 5, new GuiItem(ItemBuilder.create(AxInventoryRestore.MESSAGES.getSection("gui-items.close")).get(), event2 -> this.mainGui.close((HumanEntity)this.viewer)));
        this.mainGui.open((HumanEntity)this.viewer);
    }

    public PaginatedGui getMainGui() {
        return this.mainGui;
    }

    public UUID getRestoreUser() {
        return this.restoreUser;
    }

    public Player getViewer() {
        return this.viewer;
    }

    public String getName() {
        return this.name;
    }
}

