/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.database;

import com.artillexstudios.axinventoryrestore.AxInventoryRestore;
import com.artillexstudios.axinventoryrestore.database.impl.Base;
import com.artillexstudios.axinventoryrestore.libs.axapi.serializers.Serializers;
import com.artillexstudios.axinventoryrestore.libs.axapi.utils.StringUtils;
import com.artillexstudios.axinventoryrestore.utils.SerializationUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class Converter3 {
    private final Base base;
    private ExecutorService service;
    private AtomicInteger progress;
    private final HashMap<byte[], Integer> cache = new HashMap();

    public Converter3(Base base) {
        this.base = base;
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Migrating database... Don't stop the server while it's running!", new TagResolver[0]));
        int success = 0;
        if (this.insertInventory()) {
            ++success;
        }
        if (success == 1 && this.insertWorld()) {
            ++success;
        }
        if (success == 2 && this.convert()) {
            ++success;
        }
        if (success == 3 && this.deleteInventory()) {
            ++success;
        }
        if (success == 4 && this.deleteWorld()) {
            ++success;
        }
        this.service.shutdown();
        if (success == 5) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FF00[AxInventoryRestore] Successful conversion! Optimizing database & starting the server..", new TagResolver[0]));
        } else {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxInventoryRestore] Something went wrong while converting!", new TagResolver[0]));
        }
        base.disable();
        AxInventoryRestore.getDatabase().setup();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean insertWorld() {
        String sql = "ALTER TABLE axir_backups ADD worldId INT AFTER world;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("ALTER TABLE axir_backups ADD worldId INT AFTER world;");
                try {
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteWorld() {
        String sql = "ALTER TABLE axir_backups DROP COLUMN world;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("ALTER TABLE axir_backups DROP COLUMN world;");
                try {
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean insertInventory() {
        String sql = "ALTER TABLE axir_backups ADD inventoryId INT AFTER inventory;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("ALTER TABLE axir_backups ADD inventoryId INT AFTER inventory;");
                try {
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteInventory() {
        String sql = "ALTER TABLE axir_backups DROP COLUMN inventory;";
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("ALTER TABLE axir_backups DROP COLUMN inventory;");
                try {
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean convert() {
        this.service = Executors.newFixedThreadPool(5);
        int am = 0;
        try (Connection conn = this.base.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) FROM axir_backups;");
             ResultSet rs = stmt.executeQuery();){
            if (rs.next()) {
                am = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
        CountDownLatch latch = new CountDownLatch(am);
        this.progress = new AtomicInteger(am);
        String sql = "SELECT inventory, id, world FROM axir_backups;";
        long time = System.currentTimeMillis();
        try (Connection conn = this.base.getConnection();){
            boolean bl;
            block46: {
                PreparedStatement stmt = conn.prepareStatement("SELECT inventory, id, world FROM axir_backups;");
                try {
                    try (ResultSet rs = stmt.executeQuery();){
                        PreparedStatement stmt2 = conn.prepareStatement("UPDATE axir_backups SET inventoryId = ?, worldId = ? WHERE id = ?;");
                        while (rs.next()) {
                            InputStream stream = rs.getBinaryStream(1);
                            int id = rs.getInt(2);
                            String world = rs.getString(3);
                            this.service.submit(() -> this.insertInventory(stmt2, latch, time, stream, id, world));
                        }
                        try {
                            latch.await();
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        stmt.executeBatch();
                        stmt2.close();
                        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] Converted users!", new TagResolver[0]));
                    }
                    bl = true;
                    if (stmt == null) break block46;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void insertInventory(PreparedStatement stmt, CountDownLatch latch, long time, InputStream stream, int id, String world) {
        try {
            try {
                ItemStack[] items = SerializationUtils.invFromBits(stream);
                stmt.setInt(1, this.storeItems(Serializers.ITEM_ARRAY.serialize(items)));
                stmt.setInt(2, this.storeWorld(world));
            }
            catch (Exception ex) {
                String sql = "DELETE FROM axir_backups WHERE id = ?;";
                try (Connection conn = this.base.getConnection();
                     PreparedStatement stmt2 = conn.prepareStatement("DELETE FROM axir_backups WHERE id = ?;");){
                    stmt2.setInt(1, id);
                    stmt2.executeUpdate();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                latch.countDown();
                return;
            }
            stmt.setInt(3, id);
            int processed = this.progress.getAndDecrement();
            if (processed % 1000 == 0) {
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF6600[AxInventoryRestore] " + processed + " backups remaining (running: " + (System.currentTimeMillis() - time) + "ms)", new TagResolver[0]));
                stmt.executeBatch();
            }
            stmt.addBatch();
            latch.countDown();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            latch.countDown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int storeItems(byte[] items) {
        Integer res = this.cache.get(items);
        if (res != null) {
            return res;
        }
        String sql = "INSERT INTO axir_storage(inventory) VALUES (?);";
        try (Connection conn = this.base.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_storage(inventory) VALUES (?);", 1);){
            stmt.setBytes(1, items);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) throw new RuntimeException("Failed to save inventory!");
                int id = rs.getInt(1);
                this.cache.put(items, id);
                int n = id;
                return n;
            }
        }
        catch (SQLException ex2) {
            ex2.printStackTrace();
        }
        throw new RuntimeException("Failed to save inventory!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int storeWorld(String world) {
        String sql = "INSERT INTO axir_worlds(name) VALUES (?);";
        try (Connection conn = this.base.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO axir_worlds(name) VALUES (?);", 1);){
            stmt.setString(1, world);
            stmt.executeUpdate();
            try (ResultSet rs = stmt.getGeneratedKeys();){
                if (!rs.next()) throw new RuntimeException("Failed to save world!");
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException ex) {
            String sql0 = "SELECT id FROM axir_worlds WHERE name = ?";
            try (Connection conn2 = this.base.getConnection();
                 PreparedStatement stmt2 = conn2.prepareStatement("SELECT id FROM axir_worlds WHERE name = ?");){
                stmt2.setString(1, world);
                try (ResultSet rs = stmt2.executeQuery();){
                    if (!rs.next()) throw new RuntimeException("Failed to save world!");
                    int n = rs.getInt(1);
                    return n;
                }
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
            }
        }
        throw new RuntimeException("Failed to save world!");
    }
}

