/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.utils;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.block.implementation.Section;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class LocationUtils {
    @NotNull
    public static Location getCenterOf(@NotNull Location location, boolean keepYaw, boolean keepPitch) {
        Location loc = location.getBlock().getLocation().add(0.5, 0.5, 0.5);
        if (keepYaw) {
            loc.setYaw(location.getYaw());
        }
        if (keepPitch) {
            loc.setPitch(location.getPitch());
        }
        return loc;
    }

    public static int getNearestDirection(float x) {
        return Math.round(x / 90.0f) * 90;
    }

    public static void clampLocation(Location location) {
        double max;
        double min;
        Section section = AxGraves.CONFIG.getSection("spawn-height-limits." + location.getWorld().getName());
        if (section != null) {
            min = section.getDouble("min");
            max = section.getDouble("max");
        } else {
            switch (location.getWorld().getEnvironment()) {
                case NETHER: 
                case THE_END: {
                    min = 0.0;
                    max = 255.0;
                    break;
                }
                default: {
                    min = -64.0;
                    max = 319.0;
                }
            }
        }
        location.setY(Math.clamp(location.getY(), min, max));
    }

    @NotNull
    public static String getWorldName(World world) {
        if (world == null) {
            return "---";
        }
        return AxGraves.CONFIG.getString("world-name." + world.getName(), world.getName());
    }
}

