/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.schedulers;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.HumanEntity;

public class TickGraves {
    private static ScheduledFuture<?> future = null;

    public static void start() {
        if (future != null) {
            future.cancel(true);
        }
        future = AxGraves.EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                for (Grave grave : SpawnedGraves.getGraves()) {
                    grave.update();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Scheduler.get().runTimer(() -> {
            for (Grave grave : SpawnedGraves.getGraves()) {
                for (HumanEntity viewer : new ArrayList(grave.getGui().getViewers())) {
                    if (!Objects.equals(viewer.getWorld(), grave.getLocation().getWorld())) {
                        grave.closeInventory(viewer);
                        continue;
                    }
                    if (viewer.getLocation().distanceSquared(grave.getLocation()) <= 49.0) continue;
                    grave.closeInventory(viewer);
                }
            }
        }, 20L, 20L);
    }

    public static void stop() {
        if (future == null) {
            return;
        }
        future.cancel(true);
    }
}

