/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.listeners;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.api.events.GravePreSpawnEvent;
import com.artillexstudios.axgraves.api.events.GraveSpawnEvent;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.utils.ExperienceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class DeathListener
implements Listener {
    private static List<String> disabledWorlds;
    private static List<String> blacklistedDeathCauses;
    private static boolean overrideKeepInventory;
    private static boolean overrideKeepLevel;
    private static boolean storeItems;
    private static boolean storeXP;
    private static float xpKeepPercentage;

    public static void reload() {
        disabledWorlds = AxGraves.CONFIG.getStringList("disabled-worlds");
        blacklistedDeathCauses = AxGraves.CONFIG.getStringList("blacklisted-death-causes");
        overrideKeepInventory = AxGraves.CONFIG.getBoolean("override-keep-inventory", true);
        overrideKeepLevel = AxGraves.CONFIG.getBoolean("override-keep-level", true);
        storeItems = AxGraves.CONFIG.getBoolean("store-items", true);
        storeXP = AxGraves.CONFIG.getBoolean("store-xp", true);
        xpKeepPercentage = AxGraves.CONFIG.getFloat("xp-keep-percentage", 1.0f);
    }

    public DeathListener() {
        DeathListener.reload();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        if (disabledWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        Player player = event.getEntity();
        if (!player.hasPermission("axgraves.allowgraves")) {
            return;
        }
        if (player.getLastDamageCause() != null && blacklistedDeathCauses.contains(player.getLastDamageCause().getCause().name())) {
            return;
        }
        Location location = player.getLocation();
        location.add(0.0, -0.5, 0.0);
        GravePreSpawnEvent gravePreSpawnEvent = new GravePreSpawnEvent(player, location);
        Bukkit.getPluginManager().callEvent((Event)gravePreSpawnEvent);
        if (gravePreSpawnEvent.isCancelled()) {
            return;
        }
        List<ItemStack> drops = new ArrayList<ItemStack>();
        if (storeItems) {
            boolean store = false;
            if (!event.getKeepInventory()) {
                store = true;
                drops = new ArrayList(event.getDrops());
            } else if (overrideKeepInventory) {
                store = true;
                drops = Arrays.asList(player.getInventory().getContents());
                player.getInventory().clear();
            }
            if (store) {
                event.getDrops().clear();
            }
        }
        int xp = 0;
        if (storeXP) {
            boolean store = false;
            if (!event.getKeepLevel()) {
                store = true;
            } else if (overrideKeepLevel) {
                store = true;
                player.setLevel(0);
                player.setTotalExperience(0);
            }
            if (store) {
                xp = Math.round((float)ExperienceUtils.getExp(player) * xpKeepPercentage);
                event.setDroppedExp(0);
            }
        }
        if (drops.isEmpty() && xp == 0) {
            return;
        }
        Grave grave = new Grave(location, (OfflinePlayer)player, drops, xp, System.currentTimeMillis());
        SpawnedGraves.addGrave(grave);
        GraveSpawnEvent graveSpawnEvent = new GraveSpawnEvent(player, grave);
        Bukkit.getPluginManager().callEvent((Event)graveSpawnEvent);
    }
}

