/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types;

import com.artillexstudios.axgraves.libs.axapi.libs.snakeyaml.error.YAMLException;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.SyntaxError;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.YamlAssist;
import com.artillexstudios.axgraves.libs.axapi.libs.yamlassist.types.InvalidLine;
import java.util.ArrayList;
import java.util.List;

public class QuoteWrapRequired
extends SyntaxError {
    private final char[] invalidStartCharacters = new char[]{'\u0000', '%', '-', '.', '[', '{', ']', '}', ',', '?', ':', '*', '&', '!', '|', '>'};

    @Override
    public List<String> getSuggestions(YAMLException exception, List<String> fileLines) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int lineNumber = 1; lineNumber <= fileLines.size(); ++lineNumber) {
            String value;
            String line = this.removeIndent(fileLines.get(lineNumber - 1));
            if (!YamlAssist.getError(InvalidLine.class).isLineValid(line) || line.startsWith("#") || line.isEmpty() || (value = this.getValue(line)).equals("{}") || value.equals("[]")) continue;
            for (char invalid : this.invalidStartCharacters) {
                if (!value.startsWith(invalid + "")) continue;
                suggestions.add("Wrap value in line " + lineNumber + " into quotes.");
            }
        }
        return suggestions;
    }
}

