/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves;

import com.artillexstudios.axgraves.commands.CommandManager;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.grave.GravePlaceholders;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.config.Config;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axgraves.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axgraves.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axgraves.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axgraves.listeners.DeathListener;
import com.artillexstudios.axgraves.listeners.PlayerInteractListener;
import com.artillexstudios.axgraves.schedulers.SaveGraves;
import com.artillexstudios.axgraves.schedulers.TickGraves;
import com.artillexstudios.axgraves.utils.UpdateNotifier;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class AxGraves
extends AxPlugin {
    private static AxPlugin instance;
    public static Config CONFIG;
    public static Config LANG;
    public static MessageUtils MESSAGEUTILS;
    public static ScheduledExecutorService EXECUTOR;
    private static AxMetrics metrics;

    public static AxPlugin getInstance() {
        return instance;
    }

    @Override
    public void enable() {
        instance = this;
        new Metrics((Plugin)this, 20332);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        LANG = new Config(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(LANG.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        this.getServer().getPluginManager().registerEvents((Listener)new DeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        CommandManager.load();
        GravePlaceholders.register();
        if (CONFIG.getBoolean("save-graves.enabled", true)) {
            SpawnedGraves.loadFromFile();
        }
        TickGraves.start();
        SaveGraves.start();
        metrics = new AxMetrics(this, 20L);
        metrics.start();
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5076);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        TickGraves.stop();
        SaveGraves.stop();
        for (Grave grave : SpawnedGraves.getGraves()) {
            if (!CONFIG.getBoolean("save-graves.enabled", true)) {
                grave.remove();
            }
            if (grave.getEntity() != null) {
                grave.getEntity().remove();
            }
            if (grave.getHologram() == null) continue;
            grave.getHologram().remove();
        }
        if (CONFIG.getBoolean("save-graves.enabled", true)) {
            SpawnedGraves.saveToFile();
        }
        EXECUTOR.shutdownNow();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
        FeatureFlags.PACKET_ENTITY_TRACKER_ENABLED.set(true);
        FeatureFlags.HOLOGRAM_UPDATE_TICKS.set(5L);
        FeatureFlags.ENABLE_PACKET_LISTENERS.set(true);
        FeatureFlags.PLACEHOLDER_API_HOOK.set(true);
        FeatureFlags.PLACEHOLDER_API_IDENTIFIER.set("axgraves");
    }

    static {
        EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    }
}

