/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axgraves.libs.lamp.bukkit.brigadier.BukkitVersion;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

final class BrigadierUtil {
    private static final Field CHILDREN_FIELD;
    private static final Field LITERALS_FIELD;
    private static final Field ARGUMENTS_FIELD;
    private static final Method GET_BUKKIT_SENDER_METHOD;
    private static final Field[] CHILDREN_FIELDS;

    BrigadierUtil() {
    }

    public static void removeChild(RootCommandNode root, String name) {
        try {
            for (Field field : CHILDREN_FIELDS) {
                Map children = (Map)field.get(root);
                children.remove(name);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <S> LiteralCommandNode<S> renameLiteralNode(LiteralCommandNode<S> node, String newLiteral) {
        LiteralCommandNode clone = new LiteralCommandNode(newLiteral, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
        for (CommandNode child : node.getChildren()) {
            clone.addChild(child);
        }
        return clone;
    }

    @NotNull
    public static CommandSender getBukkitSender(Object commandSource) {
        Objects.requireNonNull(commandSource, "commandSource");
        try {
            return (CommandSender)GET_BUKKIT_SENDER_METHOD.invoke(commandSource, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> commandListenerWrapper;
            try {
                commandListenerWrapper = BukkitVersion.supports(1, 16) ? BukkitVersion.findNmsClass("commands.CommandListenerWrapper") : BukkitVersion.findNmsClass("CommandListenerWrapper");
            }
            catch (Exception e) {
                try {
                    commandListenerWrapper = Class.forName("net.minecraft.commands.CommandListenerWrapper");
                }
                catch (Exception exception) {
                    commandListenerWrapper = Class.forName("net.minecraft.commands.CommandSourceStack");
                }
            }
            CHILDREN_FIELD = CommandNode.class.getDeclaredField("children");
            LITERALS_FIELD = CommandNode.class.getDeclaredField("literals");
            ARGUMENTS_FIELD = CommandNode.class.getDeclaredField("arguments");
            for (Field field : CHILDREN_FIELDS = new Field[]{CHILDREN_FIELD, LITERALS_FIELD, ARGUMENTS_FIELD}) {
                field.setAccessible(true);
            }
            GET_BUKKIT_SENDER_METHOD = commandListenerWrapper.getDeclaredMethod("getBukkitSender", new Class[0]);
            GET_BUKKIT_SENDER_METHOD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

