/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_21_R7_paper.packet;

import com.artillexstudios.axgraves.libs.axapi.nms.v1_21_R7_paper.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_21_R7_paper.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axgraves.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axgraves.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axgraves.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.utils.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.IdDispatchCodec;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.MinecraftServer;

public final class PacketTransformer {
    private static final Function<ByteBuf, RegistryFriendlyByteBuf> decorator = RegistryFriendlyByteBuf.decorator((RegistryAccess)MinecraftServer.getServer().registryAccess());
    private static final StreamCodec<ByteBuf, Packet<? super ClientGamePacketListener>> clientboundCodec = GameProtocols.CLIENTBOUND_TEMPLATE.bind(decorator).codec();
    private final StreamCodec<ByteBuf, Packet<? super ServerGamePacketListener>> serverboundCodec;
    private static final FieldAccessor toIdAccessor = FieldAccessor.builder().withClass(IdDispatchCodec.class).withField("toId").build();
    private static final Object2IntMap<com.artillexstudios.axgraves.libs.axapi.packet.PacketType> clientboundIds = (Object2IntMap)toIdAccessor.getUnchecked(clientboundCodec);
    private final Object2IntMap<com.artillexstudios.axgraves.libs.axapi.packet.PacketType> serverboundIds;

    public PacketTransformer(ServerPlayerWrapper wrapper) {
        this.serverboundCodec = GameProtocols.SERVERBOUND_TEMPLATE.bind(decorator, (Object)wrapper.asMinecraft().connection).codec();
        this.serverboundIds = (Object2IntMap)toIdAccessor.getUnchecked(this.serverboundCodec);
    }

    public Packet<?> transformClientbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(decorator.apply(Unpooled.buffer()));
        buf.writeVarInt(ClientboundPacketTypes.forPacketType(wrapper.packetType()));
        wrapper.write(buf);
        return PacketTransformer.transformClientbound((FriendlyByteBuf)buf.buf());
    }

    public static Packet<?> transformClientbound(com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf buf) {
        return PacketTransformer.transformClientbound((FriendlyByteBuf)((FriendlyByteBufWrapper)buf).buf());
    }

    public static Packet<? super ClientGamePacketListener> transformClientbound(FriendlyByteBuf buf) {
        try {
            Packet packet = (Packet)clientboundCodec.decode((Object)buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<? super ClientGamePacketListener> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet<? super ServerGamePacketListener> transformServerbound(FriendlyByteBuf buf) {
        try {
            Packet packet = (Packet)this.serverboundCodec.decode((Object)buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<? super ServerGamePacketListener> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public Packet<?> transformServerbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(decorator.apply(Unpooled.buffer()));
        wrapper.write(buf);
        return this.transformServerbound0((FriendlyByteBuf)buf.buf());
    }

    public Packet<?> transformServerbound(com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf buf) {
        return this.transformServerbound0((FriendlyByteBuf)((FriendlyByteBufWrapper)buf).buf());
    }

    private Packet<?> transformServerbound0(FriendlyByteBuf buf) {
        try {
            Packet packet = (Packet)this.serverboundCodec.decode((Object)buf);
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformServerbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return this.transformServerbound(ctx, packet, buf -> {});
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformServerbound(Packet<?> packet) {
        return this.transformServerbound(null, packet, buf -> {});
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformServerbound(Packet<?> packet, Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        return this.transformServerbound(null, packet, consumer);
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformServerbound(ChannelHandlerContext ctx, Object packet, Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            ByteBuf buffer = PacketTransformer.alloc(ctx);
            this.serverboundCodec.encode((Object)buffer, (Object)((Packet)packet));
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer));
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer.copy()));
        } else {
            LogUtils.error("Unhandled packet class: {}", packet.getClass());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformClientbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return this.transformClientbound(ctx, packet, buf -> {});
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformClientbound(Packet<?> packet) {
        return this.transformClientbound(null, packet, buf -> {});
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformClientbound(Packet<?> packet, Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        return this.transformClientbound(null, packet, consumer);
    }

    public com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf transformClientbound(ChannelHandlerContext ctx, Object packet, Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            ByteBuf buffer = PacketTransformer.alloc(ctx);
            clientboundCodec.encode((Object)buffer, (Object)((Packet)packet));
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer));
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer.copy()));
        } else {
            LogUtils.error("Unhandled packet class: {}", packet.getClass());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf newByteBuf() {
        return PacketTransformer.newByteBuf(null, buf -> {});
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf newByteBuf(ChannelHandlerContext ctx) {
        return PacketTransformer.newByteBuf(ctx, buf -> {});
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf newByteBuf(Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        return PacketTransformer.newByteBuf(null, consumer);
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf newByteBuf(ChannelHandlerContext ctx, Consumer<com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper = new FriendlyByteBufWrapper(decorator.apply(PacketTransformer.alloc(ctx)));
        consumer.accept(wrapper);
        return wrapper;
    }

    public ByteBuf alloc() {
        return PacketTransformer.alloc(null);
    }

    public static ByteBuf alloc(ChannelHandlerContext ctx) {
        return ctx == null ? Unpooled.buffer() : ctx.alloc().buffer();
    }

    public int packetId(Object input) {
        int packetId;
        if (input instanceof Packet) {
            Packet packet = (Packet)input;
            PacketType type = packet.type();
            packetId = type.flow() == PacketFlow.CLIENTBOUND ? clientboundIds.getOrDefault((Object)type, -1) : this.serverboundIds.getOrDefault((Object)type, -1);
        } else if (input instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)input;
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            packetId = VarInt.read((ByteBuf)buffer);
            buffer.readerIndex(readerIndex);
            buffer.writerIndex(writerIndex);
        } else {
            LogUtils.warn("Unhandled packet class: {}", ClassUtils.INSTANCE.debugClass(input.getClass()));
            packetId = -1;
        }
        return packetId;
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf wrap(ByteBuf buf) {
        return new FriendlyByteBufWrapper(decorator.apply(buf));
    }

    public static com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf copy(FriendlyByteBufWrapper friendlyByteBufWrapper) {
        return PacketTransformer.wrap(friendlyByteBufWrapper.buf().copy());
    }
}

