/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.grave;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.api.events.GraveInteractEvent;
import com.artillexstudios.axgraves.api.events.GraveOpenEvent;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.hologram.Hologram;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramType;
import com.artillexstudios.axgraves.libs.axapi.hologram.HologramTypes;
import com.artillexstudios.axgraves.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.packet.wrapper.serverbound.ServerboundInteractWrapper;
import com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.ArmorStandMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.DisplayMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.entity.TextDisplayMeta;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.utils.BlacklistUtils;
import com.artillexstudios.axgraves.utils.ExperienceUtils;
import com.artillexstudios.axgraves.utils.InventoryUtils;
import com.artillexstudios.axgraves.utils.LocationUtils;
import com.artillexstudios.axgraves.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Grave {
    private static final Vector ZERO_VECTOR = new Vector(0, 0, 0);
    private final long spawned;
    private final Location location;
    private final OfflinePlayer player;
    private final String playerName;
    private final Inventory gui;
    private int storedXP;
    private final PacketEntity entity;
    private Hologram hologram;
    private boolean removed = false;

    public Grave(Location loc, @NotNull OfflinePlayer offlinePlayer, @NotNull List<ItemStack> items, int storedXP, long date) {
        items = new ArrayList<ItemStack>(items);
        items.removeIf(it -> {
            if (it == null) {
                return true;
            }
            return BlacklistUtils.isBlacklisted(it);
        });
        items.replaceAll(ItemStack::clone);
        this.location = LocationUtils.getCenterOf(loc, true, false);
        this.player = offlinePlayer;
        this.playerName = offlinePlayer.getName() == null ? AxGraves.LANG.getString("unknown-player", "???") : offlinePlayer.getName();
        this.storedXP = storedXP;
        this.spawned = date;
        this.gui = Bukkit.createInventory(null, (int)(InventoryUtils.getRequiredRows(items.size()) * 9), (String)StringUtils.formatToString(AxGraves.LANG.getString("gui-name").replace("%player%", this.playerName), new TagResolver[0]));
        LocationUtils.clampLocation(this.location);
        Player pl = offlinePlayer.getPlayer();
        if (pl != null) {
            items = InventoryUtils.reorderInventory(pl.getInventory(), items);
            if (AxGraves.LANG.getBoolean("death-message.enabled", false)) {
                AxGraves.MESSAGEUTILS.sendLang((CommandSender)pl, "death-message.message", Map.of("%world%", LocationUtils.getWorldName(this.location.getWorld()), "%x%", "" + this.location.getBlockX(), "%y%", "" + this.location.getBlockY(), "%z%", "" + this.location.getBlockZ()));
            }
        }
        items.forEach(xva$0 -> this.gui.addItem(new ItemStack[]{xva$0}));
        this.entity = NMSHandlers.getNmsHandler().createEntity(EntityType.ARMOR_STAND, this.location.clone().add(0.0, (double)(1.0f + AxGraves.CONFIG.getFloat("head-height", -1.2f)), 0.0));
        this.entity.setItem(EquipmentSlot.HELMET, WrappedItemStack.wrap(Utils.getPlayerHead(offlinePlayer)));
        ArmorStandMeta meta = (ArmorStandMeta)this.entity.meta();
        meta.small(true);
        meta.invisible(true);
        meta.setNoBasePlate(false);
        this.entity.spawn();
        if (AxGraves.CONFIG.getBoolean("rotate-head-360", true)) {
            this.entity.location().setYaw(this.location.getYaw());
            this.entity.teleport(this.entity.location());
        } else {
            this.entity.location().setYaw((float)LocationUtils.getNearestDirection(this.location.getYaw()));
            this.entity.teleport(this.entity.location());
        }
        this.entity.onInteract(event -> Scheduler.get().run(task -> this.interact(event.getPlayer(), event.getHand())));
        this.updateHologram();
    }

    public void update() {
        boolean empty;
        int items = this.countItems();
        int time = AxGraves.CONFIG.getInt("despawn-time-seconds", 180);
        boolean outOfTime = (long)time * 1000L <= System.currentTimeMillis() - this.spawned;
        boolean despawn = AxGraves.CONFIG.getBoolean("despawn-when-empty", true);
        boolean bl = empty = items == 0 && this.storedXP == 0;
        if (time != -1 && outOfTime || despawn && empty) {
            Scheduler.get().runAt(this.location, this::remove);
            return;
        }
        if (AxGraves.CONFIG.getBoolean("auto-rotation.enabled", false)) {
            this.entity.location().setYaw(this.entity.location().getYaw() + AxGraves.CONFIG.getFloat("auto-rotation.speed", 10.0f));
            this.entity.teleport(this.entity.location());
        }
    }

    public void interact(@NotNull Player opener, ServerboundInteractWrapper.InteractionHand slot) {
        if (AxGraves.CONFIG.getBoolean("interact-only-own", false) && !opener.getUniqueId().equals(this.player.getUniqueId()) && !opener.hasPermission("axgraves.admin")) {
            AxGraves.MESSAGEUTILS.sendLang((CommandSender)opener, "interact.not-your-grave", new TagResolver[0]);
            return;
        }
        GraveInteractEvent graveInteractEvent = new GraveInteractEvent(opener, this);
        Bukkit.getPluginManager().callEvent((Event)graveInteractEvent);
        if (graveInteractEvent.isCancelled()) {
            return;
        }
        if (this.storedXP != 0) {
            ExperienceUtils.changeExp(opener, this.storedXP);
            this.storedXP = 0;
        }
        if (slot != null && slot.equals((Object)ServerboundInteractWrapper.InteractionHand.MAIN_HAND) && opener.isSneaking()) {
            if (opener.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (!AxGraves.CONFIG.getBoolean("enable-instant-pickup", true)) {
                return;
            }
            if (AxGraves.CONFIG.getBoolean("instant-pickup-only-own", false) && !opener.getUniqueId().equals(this.player.getUniqueId())) {
                return;
            }
            for (ItemStack it : this.gui.getContents()) {
                Collection ar;
                if (it == null) continue;
                if (AxGraves.CONFIG.getBoolean("auto-equip-armor", true)) {
                    if ((EnchantmentTarget.ARMOR_HEAD.includes(it) || it.getType().equals((Object)Material.TURTLE_HELMET)) && opener.getInventory().getHelmet() == null) {
                        opener.getInventory().setHelmet(it);
                        it.setAmount(0);
                        continue;
                    }
                    if ((EnchantmentTarget.ARMOR_TORSO.includes(it) || it.getType().equals((Object)Material.ELYTRA)) && opener.getInventory().getChestplate() == null) {
                        opener.getInventory().setChestplate(it);
                        it.setAmount(0);
                        continue;
                    }
                    if (EnchantmentTarget.ARMOR_LEGS.includes(it) && opener.getInventory().getLeggings() == null) {
                        opener.getInventory().setLeggings(it);
                        it.setAmount(0);
                        continue;
                    }
                    if (EnchantmentTarget.ARMOR_FEET.includes(it) && opener.getInventory().getBoots() == null) {
                        opener.getInventory().setBoots(it);
                        it.setAmount(0);
                        continue;
                    }
                }
                if ((ar = opener.getInventory().addItem(new ItemStack[]{it}).values()).isEmpty()) {
                    it.setAmount(0);
                    continue;
                }
                it.setAmount(((ItemStack)ar.iterator().next()).getAmount());
            }
            this.update();
            return;
        }
        GraveOpenEvent graveOpenEvent = new GraveOpenEvent(opener, this);
        Bukkit.getPluginManager().callEvent((Event)graveOpenEvent);
        if (graveOpenEvent.isCancelled()) {
            return;
        }
        opener.openInventory(this.gui);
    }

    public void updateHologram() {
        if (this.hologram != null) {
            this.hologram.remove();
        }
        List<String> lines = AxGraves.LANG.getStringList("hologram");
        double hologramHeight = AxGraves.CONFIG.getFloat("hologram-height", 0.75f) + 1.0f;
        this.hologram = new Hologram(this.location.clone().add(0.0, Grave.getNewHeight(hologramHeight, lines.size(), 0.3f), 0.0));
        HologramPage<String, HologramType<String>> page = this.hologram.createPage(HologramTypes.TEXT);
        page.getParameters().withParameter(Grave.class, this);
        Section section = AxGraves.CONFIG.getSection("holograms");
        page.setEntityMetaHandler(m -> {
            TextDisplayMeta meta = (TextDisplayMeta)m;
            meta.seeThrough(section.getBoolean("see-through"));
            meta.alignment(TextDisplayMeta.Alignment.valueOf(section.getString("alignment").toUpperCase()));
            meta.backgroundColor(Integer.parseInt(section.getString("background-color"), 16));
            meta.lineWidth(1000);
            meta.billboardConstrain(DisplayMeta.BillboardConstrain.valueOf(section.getString("billboard").toUpperCase()));
        });
        page.setContent(String.join((CharSequence)"<reset><br>", lines));
        page.spawn();
    }

    private static double getNewHeight(double y, int lines, float lineHeight) {
        return y - (double)(lineHeight * (float)(lines - 1)) + 0.25;
    }

    public int countItems() {
        int am = 0;
        for (ItemStack it : this.gui.getContents()) {
            if (it == null) continue;
            ++am;
        }
        return am;
    }

    public void remove() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        Runnable runnable = () -> {
            SpawnedGraves.removeGrave(this);
            this.removeInventory();
            if (this.entity != null) {
                this.entity.remove();
            }
            if (this.hologram != null) {
                this.hologram.remove();
            }
        };
        if (Scheduler.get().isOwnedByCurrentRegion(this.location)) {
            runnable.run();
        } else {
            Scheduler.get().runAt(this.location, runnable);
        }
    }

    public void removeInventory() {
        this.closeInventory();
        if (AxGraves.CONFIG.getBoolean("drop-items", true)) {
            for (ItemStack it : this.gui.getContents()) {
                if (it == null) continue;
                Item item = this.location.getWorld().dropItem(this.location.clone(), it);
                if (AxGraves.CONFIG.getBoolean("dropped-item-velocity", true)) continue;
                item.setVelocity(ZERO_VECTOR);
            }
        }
        if (this.storedXP == 0) {
            return;
        }
        ExperienceOrb exp = (ExperienceOrb)this.location.getWorld().spawnEntity(this.location, EntityType.EXPERIENCE_ORB);
        exp.setExperience(this.storedXP);
    }

    private void closeInventory() {
        ArrayList viewers = new ArrayList(this.gui.getViewers());
        for (HumanEntity viewer : viewers) {
            viewer.closeInventory();
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public long getSpawned() {
        return this.spawned;
    }

    public Inventory getGui() {
        return this.gui;
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public PacketEntity getEntity() {
        return this.entity;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

