/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.commands.subcommands;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.grave.SpawnedGraves;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;
import com.artillexstudios.axgraves.utils.LocationUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public enum List {
    INSTANCE;


    public void execute(CommandSender sender) {
        boolean found = false;
        int dTime = AxGraves.CONFIG.getInt("despawn-time-seconds", 180);
        for (Grave grave : SpawnedGraves.getGraves()) {
            BaseComponent[] text;
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (!grave.getPlayer().getUniqueId().equals(player.getUniqueId()) && !sender.hasPermission("axgraves.list.other")) continue;
            }
            Location l = grave.getLocation();
            Map<String, String> map = Map.of("%player%", grave.getPlayerName(), "%world%", LocationUtils.getWorldName(l.getWorld()), "%x%", "" + l.getBlockX(), "%y%", "" + l.getBlockY(), "%z%", "" + l.getBlockZ(), "%time%", StringUtils.formatTime(dTime != -1 ? (long)dTime * 1000L - (System.currentTimeMillis() - grave.getSpawned()) : System.currentTimeMillis() - grave.getSpawned()));
            if (!found) {
                AxGraves.MESSAGEUTILS.sendFormatted(sender, AxGraves.LANG.getString("grave-list.header"), new TagResolver[0]);
                found = true;
            }
            for (BaseComponent component : text = TextComponent.fromLegacyText((String)StringUtils.formatToString(AxGraves.LANG.getString("grave-list.grave"), new HashMap<String, String>(map)))) {
                component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(Locale.ENGLISH, "/axgraves tp %s %f %f %f", l.getWorld().getName(), l.getX(), l.getY(), l.getZ())));
            }
            sender.spigot().sendMessage(text);
        }
        if (!found) {
            AxGraves.MESSAGEUTILS.sendLang(sender, "grave-list.no-graves", new TagResolver[0]);
        }
    }
}

