/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.config.adapters.primitive;

import com.artillexstudios.axgraves.libs.axapi.config.adapters.TypeAdapter;
import com.artillexstudios.axgraves.libs.axapi.config.adapters.TypeAdapterHolder;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class ShortAdapter
implements TypeAdapter<Short, Short> {
    @Override
    public Short deserialize(TypeAdapterHolder registry, Object input, Type type) {
        if (input instanceof Number) {
            Number num = (Number)input;
            return this.validate(num);
        }
        if (input instanceof String) {
            String str = (String)input;
            return this.validate(Double.parseDouble(str));
        }
        throw new IllegalArgumentException("Can't make a short from a " + String.valueOf(input.getClass()));
    }

    private Short validate(Number number) {
        long longValue;
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            v0 = bigInteger.longValueExact();
        } else {
            v0 = longValue = number.longValue();
        }
        if (longValue > 32767L || longValue < -32768L) {
            throw new IllegalArgumentException("Short value is not actually a short! Should be between %s and %s, but was %s".formatted((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, longValue));
        }
        return (short)longValue;
    }

    @Override
    public Short serialize(TypeAdapterHolder registry, Short value, Type type) {
        return value;
    }
}

