/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.grave;

import com.artillexstudios.axgraves.AxGraves;
import com.artillexstudios.axgraves.grave.Grave;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axgraves.libs.axapi.utils.StringUtils;

public class GravePlaceholders {
    private static int time;

    public static void reload() {
        time = AxGraves.CONFIG.getInt("despawn-time-seconds", 180);
    }

    public static void register() {
        GravePlaceholders.reload();
        String empty = "";
        PlaceholderHandler.register("player", handler -> {
            Grave grave = handler.raw(Grave.class);
            if (grave == null) {
                return empty;
            }
            return grave.getPlayerName();
        }, false);
        PlaceholderHandler.register("xp", handler -> {
            Grave grave = handler.raw(Grave.class);
            if (grave == null) {
                return empty;
            }
            return String.valueOf(grave.getStoredXP());
        }, false);
        PlaceholderHandler.register("item", handler -> {
            Grave grave = handler.raw(Grave.class);
            if (grave == null) {
                return empty;
            }
            return String.valueOf(grave.countItems());
        }, false);
        PlaceholderHandler.register("despawn-time", handler -> {
            Grave grave = handler.raw(Grave.class);
            if (grave == null) {
                return empty;
            }
            long spawned = grave.getSpawned();
            return StringUtils.formatTime(time != -1 ? (long)time * 1000L - (System.currentTimeMillis() - spawned) : System.currentTimeMillis() - spawned);
        }, false);
    }
}

