/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.lamp.core;

import com.artillexstudios.axgraves.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axgraves.libs.lamp.command.CommandParameter;
import com.artillexstudios.axgraves.libs.lamp.core.BaseCommandDispatcher;
import com.artillexstudios.axgraves.libs.lamp.core.BaseCommandHandler;
import com.artillexstudios.axgraves.libs.lamp.core.EitherParameter;
import com.artillexstudios.axgraves.libs.lamp.process.ParameterResolver;
import com.artillexstudios.axgraves.libs.lamp.process.ValueResolver;
import com.artillexstudios.axgraves.libs.lamp.process.ValueResolverFactory;
import com.artillexstudios.axgraves.libs.lamp.util.Either;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum EitherValueResolverFactory implements ValueResolverFactory
{
    INSTANCE;


    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        Class<?> rawType = parameter.getType();
        if (!Either.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type[] types = EitherParameter.getTypes(parameter);
        EitherParameter first = EitherValueResolverFactory.generate(parameter, types[0]);
        EitherParameter second = EitherValueResolverFactory.generate(parameter, types[1]);
        return context -> {
            ArgumentStack original = context.arguments().copy();
            try {
                return Either.first(first.getResolver().resolve(context));
            }
            catch (Throwable t) {
                ((BaseCommandDispatcher.ValueContextR)context).argumentStack = original;
                return Either.second(second.getResolver().resolve(context));
            }
        };
    }

    private static EitherParameter generate(CommandParameter parameter, Type type) {
        EitherParameter either = new EitherParameter(parameter, type);
        ParameterResolver<Object> resolver = ((BaseCommandHandler)parameter.getCommandHandler()).getResolver(either);
        if (resolver == null) {
            throw new IllegalStateException("Unable to find a resolver for parameter type " + either.getType());
        }
        if (!resolver.mutatesArguments()) {
            throw new IllegalStateException("Only value-based arguments are allowed in the Either type (found " + either.getType() + ")");
        }
        either.setResolver(resolver);
        return either;
    }
}

