/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper;

import com.artillexstudios.axgraves.libs.axapi.collections.RegistrationFailedException;
import com.artillexstudios.axgraves.libs.axapi.collections.Registry;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.ItemStackSerializer;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper.ServerWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper.WorldWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.Wrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.WrapperMapper;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.exception.UnknownWrappedException;
import com.artillexstudios.axgraves.libs.axapi.utils.logging.LogUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WrapperMapperRegistry {
    private static final Registry<String, WrapperMapper<?>> mappers = new Registry();
    public static final WrapperMapper<ServerPlayerWrapper> SERVER_PLAYER = WrapperMapperRegistry.register("server_player", object -> {
        if (object instanceof ServerPlayerWrapper) {
            ServerPlayerWrapper serverPlayerWrapper = (ServerPlayerWrapper)object;
            return serverPlayerWrapper;
        }
        if (object instanceof Player) {
            Player player = (Player)object;
            return new ServerPlayerWrapper(player);
        }
        if (object instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)object;
            return new ServerPlayerWrapper(serverPlayer);
        }
        throw new UnknownWrappedException("Could not wrap " + String.valueOf(object) + ", due to there being no mapper for it's class: " + String.valueOf(object.getClass()) + "!");
    });
    public static final WrapperMapper<WorldWrapper> WORLD = WrapperMapperRegistry.register("world", object -> {
        if (object instanceof WorldWrapper) {
            WorldWrapper worldWrapper = (WorldWrapper)object;
            return worldWrapper;
        }
        if (object instanceof World) {
            World world = (World)object;
            return new WorldWrapper(world);
        }
        if (object instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)object;
            return new WorldWrapper(serverLevel);
        }
        throw new UnknownWrappedException("Could not wrap " + String.valueOf(object) + ", due to there being no mapper for it's class: " + String.valueOf(object.getClass()) + "!");
    });
    public static final WrapperMapper<ServerWrapper> SERVER = WrapperMapperRegistry.register("server", object -> ServerWrapper.INSTANCE);
    public static final WrapperMapper<WrappedItemStack> ITEM_STACK = WrapperMapperRegistry.register("item_stack", object -> {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object selector0$temp = object2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WrappedItemStack.class, ItemStack.class, String.class, byte[].class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                WrappedItemStack wrapped;
                yield wrapped = (WrappedItemStack)selector0$temp;
            }
            case 1 -> {
                ItemStack itemStack = (ItemStack)selector0$temp;
                yield new WrappedItemStack(itemStack);
            }
            case 2 -> {
                String snbt = (String)selector0$temp;
                yield new WrappedItemStack(ItemStackSerializer.INSTANCE.deserializeFromSnbt(snbt));
            }
            case 3 -> {
                byte[] bytes = (byte[])selector0$temp;
                yield new WrappedItemStack(ItemStackSerializer.INSTANCE.deserializeFromBytes(bytes));
            }
            default -> throw new UnknownWrappedException("Could not wrap " + String.valueOf(object) + ", due to there being no mapper for it's class: " + String.valueOf(object.getClass()) + "!");
        };
    });

    public static <Z extends Wrapper<?>, T extends WrapperMapper<Z>> T register(String id, WrapperMapper<Z> mapper) {
        try {
            mappers.register(id, mapper);
        }
        catch (RegistrationFailedException exception) {
            LogUtils.error("An exception occurred while registering mapper {}!", id, exception);
        }
        return (T)mapper;
    }

    public static <T extends WrapperMapper<?>> T mapper(String id) {
        try {
            return (T)mappers.get(id);
        }
        catch (RegistrationFailedException exception) {
            LogUtils.error("Failed to find mapper {}! This is an issue with the code, and it should be reported to the developer of the plugin!", id, exception);
            return null;
        }
    }
}

