/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.packet;

import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R4.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axgraves.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axgraves.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axgraves.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axgraves.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axgraves.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axgraves.libs.axapi.utils.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.IdDispatchCodec;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.MinecraftServer;

public final class PacketTransformer {
    private static final Function<ByteBuf, RegistryFriendlyByteBuf> decorator = RegistryFriendlyByteBuf.a((IRegistryCustom)MinecraftServer.getServer().bc());
    private static final StreamCodec<ByteBuf, Packet<? super PacketListenerPlayOut>> clientboundCodec = GameProtocols.b.bind(decorator).c();
    private static final StreamCodec<ByteBuf, Packet<? super PacketListenerPlayIn>> serverboundCodec = GameProtocols.a.bind(decorator).c();
    private static final FieldAccessor toIdAccessor = FieldAccessor.builder().withClass(IdDispatchCodec.class).withField("d").build();
    private static final Object2IntMap<com.artillexstudios.axgraves.libs.axapi.packet.PacketType> clientboundIds = (Object2IntMap)toIdAccessor.getUnchecked(clientboundCodec);
    private static final Object2IntMap<com.artillexstudios.axgraves.libs.axapi.packet.PacketType> serverboundIds = (Object2IntMap)toIdAccessor.getUnchecked(serverboundCodec);

    public static Packet<?> transformClientbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(decorator.apply(Unpooled.buffer()));
        buf.writeVarInt(ClientboundPacketTypes.forPacketType(wrapper.packetType()));
        wrapper.write(buf);
        return PacketTransformer.transformClientbound((PacketDataSerializer)buf.buf());
    }

    public static Packet<?> transformClientbound(FriendlyByteBuf buf) {
        return PacketTransformer.transformClientbound((PacketDataSerializer)((FriendlyByteBufWrapper)buf).buf());
    }

    public static Packet<? super PacketListenerPlayOut> transformClientbound(PacketDataSerializer buf) {
        try {
            Packet packet = (Packet)clientboundCodec.decode((Object)buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<? super PacketListenerPlayOut> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static Packet<? super PacketListenerPlayIn> transformServerbound(PacketDataSerializer buf) {
        try {
            Packet packet = (Packet)serverboundCodec.decode((Object)buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<? super PacketListenerPlayIn> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static Packet<?> transformServerbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(decorator.apply(Unpooled.buffer()));
        wrapper.write(buf);
        return PacketTransformer.transformServerbound0((PacketDataSerializer)buf.buf());
    }

    public static Packet<?> transformServerbound(FriendlyByteBuf buf) {
        return PacketTransformer.transformServerbound0((PacketDataSerializer)((FriendlyByteBufWrapper)buf).buf());
    }

    private static Packet<?> transformServerbound0(PacketDataSerializer buf) {
        try {
            Packet packet = (Packet)serverboundCodec.decode((Object)buf);
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static FriendlyByteBufWrapper transformServerbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return PacketTransformer.transformServerbound(ctx, packet, buf -> {});
    }

    public static FriendlyByteBufWrapper transformServerbound(Packet<?> packet) {
        return PacketTransformer.transformServerbound(null, packet, buf -> {});
    }

    public static FriendlyByteBufWrapper transformServerbound(Packet<?> packet, Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.transformServerbound(null, packet, consumer);
    }

    public static FriendlyByteBufWrapper transformServerbound(ChannelHandlerContext ctx, Object packet, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            ByteBuf buffer = PacketTransformer.alloc(ctx);
            serverboundCodec.encode((Object)buffer, (Object)((Packet)packet));
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer));
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer.copy()));
        } else {
            LogUtils.error("Unhandled packet class: {}", packet.getClass());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public static FriendlyByteBufWrapper transformClientbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return PacketTransformer.transformClientbound(ctx, packet, buf -> {});
    }

    public static FriendlyByteBufWrapper transformClientbound(Packet<?> packet) {
        return PacketTransformer.transformClientbound(null, packet, buf -> {});
    }

    public static FriendlyByteBufWrapper transformClientbound(Packet<?> packet, Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.transformClientbound(null, packet, consumer);
    }

    public static FriendlyByteBufWrapper transformClientbound(ChannelHandlerContext ctx, Object packet, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            ByteBuf buffer = PacketTransformer.alloc(ctx);
            clientboundCodec.encode((Object)buffer, (Object)((Packet)packet));
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer));
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(decorator.apply(buffer.copy()));
        } else {
            LogUtils.error("Unhandled packet class: {}", packet.getClass());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public static FriendlyByteBufWrapper newByteBuf() {
        return PacketTransformer.newByteBuf(null, buf -> {});
    }

    public static FriendlyByteBufWrapper newByteBuf(ChannelHandlerContext ctx) {
        return PacketTransformer.newByteBuf(ctx, buf -> {});
    }

    public static FriendlyByteBufWrapper newByteBuf(Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.newByteBuf(null, consumer);
    }

    public static FriendlyByteBufWrapper newByteBuf(ChannelHandlerContext ctx, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper = new FriendlyByteBufWrapper(decorator.apply(PacketTransformer.alloc(ctx)));
        consumer.accept(wrapper);
        return wrapper;
    }

    public static ByteBuf alloc() {
        return PacketTransformer.alloc(null);
    }

    public static ByteBuf alloc(ChannelHandlerContext ctx) {
        return ctx == null ? Unpooled.buffer() : ctx.alloc().buffer();
    }

    public static int packetId(Object input) {
        int packetId;
        if (input instanceof Packet) {
            Packet packet = (Packet)input;
            PacketType type = packet.a();
            packetId = type.a() == EnumProtocolDirection.b ? clientboundIds.getOrDefault((Object)type, -1) : serverboundIds.getOrDefault((Object)type, -1);
        } else if (input instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)input;
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            packetId = VarInt.a((ByteBuf)buffer);
            buffer.readerIndex(readerIndex);
            buffer.writerIndex(writerIndex);
        } else {
            LogUtils.warn("Unhandled packet class: {}", ClassUtils.INSTANCE.debugClass(input.getClass()));
            packetId = -1;
        }
        return packetId;
    }

    public static FriendlyByteBufWrapper wrap(ByteBuf buf) {
        return new FriendlyByteBufWrapper(decorator.apply(buf));
    }

    public static FriendlyByteBufWrapper copy(FriendlyByteBufWrapper friendlyByteBufWrapper) {
        return PacketTransformer.wrap(friendlyByteBufWrapper.buf().copy());
    }
}

