/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.entity;

import com.artillexstudios.axgraves.libs.axapi.AxPlugin;
import com.artillexstudios.axgraves.libs.axapi.collections.RawReferenceOpenHashSet;
import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.hologram.Holograms;
import com.artillexstudios.axgraves.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axgraves.libs.axapi.hologram.page.LineData;
import com.artillexstudios.axgraves.libs.axapi.hologram.page.TextDisplayHologramPage;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.entity.Serializers;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.items.WrappedItemStack;
import com.artillexstudios.axgraves.libs.axapi.nms.v1_20_R3.wrapper.ServerWrapper;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.EntityMetaFactory;
import com.artillexstudios.axgraves.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axgraves.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axgraves.libs.axapi.utils.RandomStringGenerator;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PacketEntity
implements com.artillexstudios.axgraves.libs.axapi.packetentity.PacketEntity {
    private final int id;
    private final EntityMeta meta;
    private final EntityTypes<?> type;
    private final VecDeltaCodec codec = new VecDeltaCodec();
    private final Set<Player> invertedVisibilityEntities = Collections.newSetFromMap(new WeakHashMap());
    private final NonNullList<ItemStack> handSlots;
    private final NonNullList<ItemStack> armorSlots;
    private Location location;
    private volatile EntityTracker.TrackedEntity tracker;
    private List<DataWatcher.b<?>> trackedValues;
    private Vec3D vec3;
    private volatile boolean shouldTeleport = false;
    private volatile boolean itemDirty = false;
    private boolean visibleByDefault = true;
    private int riddenEntityId = -1;
    private Consumer<PacketEntityInteractEvent> interactConsumer;
    private boolean hasInvertedVisibility = false;
    private float yHeadRot = 0.0f;
    private int viewDistanceSquared = 1024;
    private UUID uuid = UUID.randomUUID();

    public PacketEntity(EntityType entityType, Location location) {
        this.id = ServerWrapper.INSTANCE.nextEntityId();
        this.type = EntityTypes.a((String)entityType.getName()).orElse(EntityTypes.d);
        this.meta = EntityMetaFactory.getForType(entityType);
        this.location = location;
        this.handSlots = NonNullList.a((int)2, (Object)ItemStack.f);
        this.armorSlots = NonNullList.a((int)4, (Object)ItemStack.f);
    }

    private static List<DataWatcher.b<?>> transform(List<Metadata.DataItem<?>> toTransform) {
        ArrayList<DataWatcher.b> dataValues = null;
        if (toTransform != null) {
            dataValues = new ArrayList<DataWatcher.b>(toTransform.size());
            for (Metadata.DataItem<?> dataItem : toTransform) {
                Serializers.Transformer transformer = Serializers.transformer(dataItem.serializer());
                dataValues.add(new DataWatcher.b(dataItem.id(), transformer.serializer(), transformer.transform(dataItem.getValue())));
            }
        }
        return dataValues;
    }

    private static PacketPlayOutSpawnEntity getAddEntityPacket(PacketEntity entity) {
        return new PacketPlayOutSpawnEntity(entity.id(), entity.uuid, entity.location().getX(), entity.location().getY(), entity.location().getZ(), entity.location().getPitch(), entity.location().getYaw(), entity.type, 1, Vec3D.b, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teleport(Location location) {
        VecDeltaCodec vecDeltaCodec = this.codec;
        synchronized (vecDeltaCodec) {
            this.location = location;
            this.vec3 = new Vec3D(location.getX(), location.getY(), location.getZ());
            this.shouldTeleport = true;
        }
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public EntityMeta meta() {
        return this.meta;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int viewDistanceSquared() {
        return this.viewDistanceSquared;
    }

    @Override
    public void viewDistance(int blocks) {
        this.viewDistanceSquared = blocks * blocks;
    }

    @Override
    public void spawn() {
        this.meta.metadata().markNotDirty();
        this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
        ((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).tracker.addEntity(this);
    }

    @Override
    public void hide(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        } else {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        }
    }

    @Override
    public void show(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        } else {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        }
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.visibleByDefault = visible;
    }

    @Override
    public void setItem(EquipmentSlot slot, com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack item) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            this.handSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.f : ((WrappedItemStack)item).itemStack));
        } else {
            this.armorSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.f : ((WrappedItemStack)item).itemStack));
        }
        this.itemDirty = true;
    }

    @Override
    public com.artillexstudios.axgraves.libs.axapi.items.WrappedItemStack getItem(EquipmentSlot slot) {
        return new WrappedItemStack(slot.getType() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.armorSlots.get(slot.getIndex()) : (ItemStack)this.handSlots.get(slot.getIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendChanges() {
        List<Metadata.DataItem<?>> items = this.meta.metadata().packDirty();
        if (items != null) {
            List<DataWatcher.b<?>> dirty = PacketEntity.transform(items);
            this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
            HologramPage<?, ?> page = Holograms.byId(this.id);
            if (page == null || !page.containsPlaceholders()) {
                this.tracker.broadcast(new PacketPlayOutEntityMetadata(this.id, dirty));
            } else {
                PlaceholderParameters parameters = new PlaceholderParameters();
                parameters.merge(page.getParameters());
                for (Object player : RawReferenceOpenHashSet.rawSet(this.tracker.seenBy)) {
                    if (player == null) continue;
                    ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                    parameters.withParameter(Player.class, (Player)wrapper.wrapped());
                    wrapper.sendPacket(new PacketPlayOutEntityMetadata(this.id, this.translate(parameters, page, dirty)));
                }
            }
        }
        if (this.itemDirty) {
            this.itemDirty = false;
            ArrayList equipments = Lists.newArrayList();
            for (EnumItemSlot slot : EnumItemSlot.values()) {
                ItemStack item = this.getItemBySlot(slot);
                if (item != null && !item.b()) {
                    ItemStack sanitised = item.p();
                    equipments.add(Pair.of((Object)slot, (Object)sanitised));
                    continue;
                }
                equipments.add(Pair.of((Object)slot, (Object)ItemStack.f));
            }
            if (!equipments.isEmpty()) {
                this.tracker.broadcast(new PacketPlayOutEntityEquipment(this.id, (List)equipments));
            }
        }
        if (this.shouldTeleport) {
            VecDeltaCodec vecDeltaCodec = this.codec;
            synchronized (vecDeltaCodec) {
                this.shouldTeleport = false;
                long k = this.codec.a(this.vec3);
                long l = this.codec.b(this.vec3);
                long i1 = this.codec.c(this.vec3);
                boolean flag6 = k < -32768L || k > 32767L || l < -32768L || l > 32767L || i1 < -32768L || i1 > 32767L;
                this.codec.e(this.vec3);
                if (!flag6) {
                    this.tracker.broadcast(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.id, (short)k, (short)l, (short)i1, (byte)(this.location.getYaw() * 256.0f / 360.0f), (byte)(this.location.getPitch() * 256.0f / 360.0f), true));
                } else {
                    PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.buffer());
                    byteBuf.c(this.id);
                    byteBuf.a(this.location.getX());
                    byteBuf.a(this.location.getY());
                    byteBuf.a(this.location.getZ());
                    byteBuf.k((int)((byte)(this.location.getYaw() * 256.0f / 360.0f)));
                    byteBuf.k((int)((byte)(this.location.getPitch() * 256.0f / 360.0f)));
                    byteBuf.a(true);
                    this.tracker.broadcast(new PacketPlayOutEntityTeleport(byteBuf));
                    byteBuf.release();
                }
            }
        }
    }

    @Override
    public void removePairing(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (this.type == EntityTypes.bv) {
            serverPlayer.c.b((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.uuid)));
        }
        serverPlayer.c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.id}));
    }

    @Override
    public void addPairing(Player player) {
        PacketDataSerializer buf;
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.type == EntityTypes.bv) {
            String name = RandomStringGenerator.lowercase().generate(15);
            list.add(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.a, ClientboundPlayerInfoUpdatePacket.a.f, ClientboundPlayerInfoUpdatePacket.a.d), new ClientboundPlayerInfoUpdatePacket.b(this.uuid, new GameProfile(this.uuid, name), true, 0, EnumGamemode.a, (IChatBaseComponent)ComponentSerializer.INSTANCE.toVanilla((Component)Component.text((String)RandomStringGenerator.lowercase().generate(15))), null)));
        }
        list.add(PacketEntity.getAddEntityPacket(this));
        if (this.trackedValues != null) {
            HologramPage<?, ?> page = Holograms.byId(this.id);
            if (page == null || !page.containsPlaceholders()) {
                list.add(new PacketPlayOutEntityMetadata(this.id, this.trackedValues));
            } else {
                list.add(new PacketPlayOutEntityMetadata(this.id, this.translate(new PlaceholderParameters().merge(page.getParameters()).withParameter(Player.class, player), page, this.trackedValues)));
            }
        }
        ArrayList equipments = Lists.newArrayList();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            ItemStack item = this.getItemBySlot(slot);
            if (item == null || item.b()) continue;
            ItemStack sanitised = item.p();
            equipments.add(Pair.of((Object)slot, (Object)sanitised));
        }
        if (!equipments.isEmpty()) {
            list.add(new PacketPlayOutEntityEquipment(this.id, (List)equipments));
        }
        if (this.riddenEntityId != -1) {
            buf = new PacketDataSerializer(Unpooled.buffer());
            buf.c(this.riddenEntityId);
            buf.a(new int[]{this.id});
            list.add(new PacketPlayOutMount(buf));
            buf.release();
        }
        buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.id);
        buf.k((int)((byte)MathHelper.d((float)(this.yHeadRot * 256.0f / 360.0f))));
        list.add(new PacketPlayOutEntityHeadRotation(buf));
        buf.release();
        serverPlayer.c.b((Packet)new ClientboundBundlePacket(list));
    }

    @Override
    public boolean canSee(Player player) {
        if (!this.hasInvertedVisibility) {
            return this.visibleByDefault;
        }
        return this.visibleByDefault ^ this.invertedVisibilityEntities.contains(player);
    }

    @Override
    public void remove() {
        ((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).tracker.removeEntity(this);
    }

    @Override
    public void onInteract(Consumer<PacketEntityInteractEvent> event) {
        this.interactConsumer = event;
    }

    @Override
    public void callInteract(PacketEntityInteractEvent event) {
        if (this.interactConsumer != null) {
            this.interactConsumer.accept(event);
        }
    }

    @Override
    public void ride(int entityId) {
        this.unRide(this.riddenEntityId);
        this.riddenEntityId = entityId;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.riddenEntityId);
        buf.a(new int[]{this.id});
        this.tracker.broadcast(new PacketPlayOutMount(buf));
        buf.release();
    }

    @Override
    public void unRide(int entityId) {
        if (this.riddenEntityId == -1) {
            return;
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.riddenEntityId);
        buf.a(new int[0]);
        this.tracker.broadcast(new PacketPlayOutMount(buf));
        buf.release();
        this.riddenEntityId = -1;
    }

    @Override
    public int riddenEntity() {
        return this.riddenEntityId;
    }

    @Override
    public void rotate(float yaw, float pitch) {
        this.location.setYaw(yaw);
        this.location.setPitch(pitch);
        this.tracker.broadcast(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.id, (byte)MathHelper.d((float)(yaw * 256.0f / 360.0f)), (byte)MathHelper.d((float)(pitch * 256.0f / 360.0f)), true));
    }

    @Override
    public void rotateHead(float yaw) {
        this.yHeadRot = yaw;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.id);
        buf.k((int)((byte)MathHelper.d((float)(yaw * 256.0f / 360.0f))));
        PacketPlayOutEntityHeadRotation packet = new PacketPlayOutEntityHeadRotation(buf);
        this.tracker.broadcast(packet);
        buf.release();
    }

    @Override
    public void update() {
        List<DataWatcher.b<?>> transformed = PacketEntity.transform(this.meta.metadata().packForNameUpdate());
        HologramPage<?, ?> page = Holograms.byId(this.id);
        if (page == null || this.tracker == null || !page.containsPlaceholders()) {
            return;
        }
        PlaceholderParameters parameters = new PlaceholderParameters();
        parameters.merge(page.getParameters());
        for (Object player : RawReferenceOpenHashSet.rawSet(this.tracker.seenBy)) {
            if (player == null) continue;
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            parameters.withParameter(Player.class, (Player)wrapper.wrapped());
            wrapper.sendPacket(new PacketPlayOutEntityMetadata(this.id, this.translate(parameters, page, transformed)));
        }
    }

    private List<DataWatcher.b<?>> translate(PlaceholderParameters parameters, HologramPage<?, ?> page, List<DataWatcher.b<?>> values) {
        if (!page.containsPlaceholders()) {
            return values;
        }
        ArrayList dataValues = new ArrayList(values);
        ListIterator<DataWatcher.b> iterator = dataValues.listIterator();
        while (iterator.hasNext()) {
            DataWatcher.b value = (DataWatcher.b)iterator.next();
            if (value.a() != 23 || !(page instanceof TextDisplayHologramPage)) continue;
            TextDisplayHologramPage textPage = (TextDisplayHologramPage)page;
            IChatMutableComponent components = IChatMutableComponent.a((ComponentContents)LiteralContents.c);
            for (LineData lineData : textPage.getData()) {
                if (!lineData.containsPlaceholders()) {
                    components.b((IChatBaseComponent)lineData.component());
                    continue;
                }
                String parsed = PlaceholderHandler.parseWithPlaceholderAPI(lineData.content(), parameters);
                components.b((IChatBaseComponent)placeholderFormatCache.get((Object)parsed));
            }
            iterator.remove();
            iterator.add(new DataWatcher.b(value.a(), value.b(), (Object)components));
            break;
        }
        return dataValues;
    }

    private ItemStack getItemBySlot(EnumItemSlot slot) {
        return switch (slot.a()) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.Function.b -> (ItemStack)this.armorSlots.get(slot.b());
            case EnumItemSlot.Function.a -> (ItemStack)this.handSlots.get(slot.b());
        };
    }
}

