/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi;

import com.artillexstudios.axgraves.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axgraves.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axgraves.libs.axapi.gui.AnvilListener;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.InventoryUpdater;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.listener.InventoryClickListener;
import com.artillexstudios.axgraves.libs.axapi.gui.inventory.renderer.InventoryRenderers;
import com.artillexstudios.axgraves.libs.axapi.hologram.Holograms;
import com.artillexstudios.axgraves.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axgraves.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axgraves.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axgraves.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axgraves.libs.axapi.packet.PacketEvents;
import com.artillexstudios.axgraves.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axgraves.libs.axapi.packet.listeners.BuiltinPacketListener;
import com.artillexstudios.axgraves.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axgraves.libs.axapi.particle.ParticleTypes;
import com.artillexstudios.axgraves.libs.axapi.placeholders.PlaceholderAPIHook;
import com.artillexstudios.axgraves.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axgraves.libs.axapi.utils.featureflags.FeatureFlags;
import java.io.File;
import java.net.URLClassLoader;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.classloader.URLClassLoaderWrapper;

public abstract class AxPlugin
extends JavaPlugin {
    public EntityTracker tracker;

    public AxPlugin() {
        DependencyManager manager = new DependencyManager(this.getDescription(), new File(this.getDataFolder(), "libs"), URLClassLoaderWrapper.wrap((URLClassLoader)this.getClassLoader()));
        DependencyManagerWrapper wrapper = new DependencyManagerWrapper(manager);
        wrapper.dependency("org{}apache{}commons:commons-math3:3.6.1");
        wrapper.dependency("com{}github{}ben-manes{}caffeine:caffeine:3.1.8");
        wrapper.relocate("org{}apache{}commons{}math3", "com.artillexstudios.axgraves.libs.axapi.libs.math3");
        wrapper.relocate("com{}github{}benmanes", "com.artillexstudios.axgraves.libs.axapi.libs.caffeine");
        try {
            Class.forName("net.kyori.adventure.Adventure", false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            wrapper.dependency("net{}kyori:adventure-api:4.25.0");
        }
        this.dependencies(wrapper);
        manager.load();
        FeatureFlags.refresh(this);
        this.updateFlags();
    }

    public void updateFlags() {
    }

    public void onEnable() {
        if (!NMSHandlers.British.initialise(this)) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ComponentSerializer.INSTANCE.refresh();
        DataComponents.setDataComponentImpl(NMSHandlers.getNmsHandler().dataComponents());
        Scheduler.scheduler.init(this);
        if (((Boolean)FeatureFlags.PACKET_ENTITY_TRACKER_ENABLED.get()).booleanValue()) {
            this.tracker = new EntityTracker(this);
            this.tracker.startTicking();
        }
        if (((Boolean)FeatureFlags.ENABLE_PACKET_LISTENERS.get()).booleanValue()) {
            PacketEvents.INSTANCE.addListener(new BuiltinPacketListener(this.tracker));
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerQuitEvent(@NotNull PlayerQuitEvent event) {
                InventoryRenderers.disconnect(event.getPlayer().getUniqueId());
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(event.getPlayer());
                if (((Boolean)FeatureFlags.ENABLE_PACKET_LISTENERS.get()).booleanValue()) {
                    wrapper.uninject();
                }
                if (AxPlugin.this.tracker == null) {
                    return;
                }
                AxPlugin.this.tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }

            @EventHandler
            public void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(event.getPlayer());
                if (!((Boolean)FeatureFlags.ENABLE_PACKET_LISTENERS.get()).booleanValue()) {
                    return;
                }
                wrapper.inject();
            }

            @EventHandler
            public void onPacketEntityInteractEvent(@NotNull PacketEntityInteractEvent event) {
                event.getPacketEntity().callInteract(event);
            }

            @EventHandler
            public void onPlayerChangedWorldEvent(@NotNull PlayerChangedWorldEvent event) {
                if (AxPlugin.this.tracker == null) {
                    return;
                }
                AxPlugin.this.tracker.untrackFor(ServerPlayerWrapper.wrap(event.getPlayer()));
            }
        }, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AnvilListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        if ((Long)FeatureFlags.HOLOGRAM_UPDATE_TICKS.get() > 0L) {
            Holograms.startTicking();
        }
        if (((Boolean)FeatureFlags.USE_INVENTORY_UPDATER.get()).booleanValue()) {
            InventoryUpdater.INSTANCE.start(this);
        }
        ParticleTypes.init();
        ClientboundPacketTypes.init();
        ServerboundPacketTypes.init();
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.inject();
        }
        this.enable();
        if (((Boolean)FeatureFlags.PLACEHOLDER_API_HOOK.get()).booleanValue() && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook(this).register();
        }
    }

    public void enable() {
    }

    public void onLoad() {
        this.load();
    }

    public void dependencies(DependencyManagerWrapper manager) {
    }

    public void load() {
    }

    public void onDisable() {
        this.disable();
        Scheduler.get().cancelAll();
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            wrapper.uninject();
        }
        if (this.tracker != null) {
            this.tracker.shutdown();
        }
        Holograms.shutdown();
        InventoryUpdater.INSTANCE.shutdown();
    }

    public void disable() {
    }

    public void reload() {
    }

    public long reloadWithTime() {
        long start = System.currentTimeMillis();
        this.reload();
        return System.currentTimeMillis() - start;
    }
}

