/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.utils;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.libs.axapi.libs.yamlassist.YamlAssist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final Path PLUGIN_DIRECTORY = AxEnvoyPlugin.getInstance().getDataFolder().toPath();
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static boolean getSuggestions(File file, Logger logger) {
        List<String> suggestions = YamlAssist.getSuggestions(file);
        if (suggestions.isEmpty()) {
            return true;
        }
        logger.error("Can't load yaml file: {}", (Object)file.toPath());
        logger.error("Possible solutions:");
        for (String suggestion : suggestions) {
            logger.error(" - {}", (Object)suggestion);
        }
        return false;
    }

    public static void extractFile(Class<?> clazz, String filename, Path outDir, boolean replace) {
        try (InputStream in = clazz.getResourceAsStream("/" + filename);){
            if (in == null) {
                RuntimeException exception = new RuntimeException("Could not read file from jar! (" + filename + ")");
                LOGGER.error("Could not find file {} in the plugin's assets!", (Object)filename, (Object)exception);
                return;
            }
            Path path = outDir.resolve(filename);
            if (!Files.exists(path, new LinkOption[0]) || replace) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException exception) {
            LOGGER.error("An unexpected error occurred while extracting file {} from plugin's assets!", (Object)filename, (Object)exception);
        }
    }

    public static void copyFromResource(@NotNull String path) {
        try (ZipFile zip = new ZipFile(Paths.get(((Object)((Object)AxEnvoyPlugin.getInstance())).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toFile());){
            Iterator<? extends ZipEntry> it = zip.entries().asIterator();
            while (it.hasNext()) {
                ZipEntry entry = it.next();
                if (!entry.getName().startsWith(path + "/") || !entry.getName().endsWith(".yaml") && !entry.getName().endsWith(".yml")) continue;
                InputStream resource = AxEnvoyPlugin.getInstance().getResource(entry.getName());
                if (resource == null) {
                    LOGGER.error("Could not find file {} in plugin's assets!", (Object)entry.getName());
                    continue;
                }
                Files.copy(resource, PLUGIN_DIRECTORY.resolve(entry.getName()), new CopyOption[0]);
            }
        }
        catch (IOException | URISyntaxException exception) {
            LOGGER.error("An unexpected error occurred while extracting directory {} from plugin's assets!", (Object)path, (Object)exception);
        }
    }
}

