/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.utils;

import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.Scheduler;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Vex;
import org.jetbrains.annotations.NotNull;

public class FallingBlockChecker {
    private static final ConcurrentLinkedQueue<SpawnedCrate> fallingCrates = new ConcurrentLinkedQueue();

    public static void start() {
        Scheduler.get().runAsyncTimer(task -> {
            Iterator<SpawnedCrate> crateIterator = fallingCrates.iterator();
            while (crateIterator.hasNext()) {
                SpawnedCrate next = crateIterator.next();
                FallingBlock fallingBlock = next.getFallingBlock();
                Vex vex = next.getVex();
                if (fallingBlock == null || vex == null) continue;
                Location finishLocation = next.getFinishLocation();
                Location currentLocation = vex.getLocation();
                if (next.getVex() == null || !finishLocation.getWorld().equals((Object)currentLocation.getWorld()) || finishLocation.getBlockX() != currentLocation.getBlockX() || finishLocation.getBlockY() != currentLocation.getBlockY() || finishLocation.getBlockZ() != currentLocation.getBlockZ()) continue;
                crateIterator.remove();
                next.setFallingBlock(null);
                next.setVex(null);
                Scheduler.get().runAt(fallingBlock.getLocation(), arg_0 -> FallingBlockChecker.lambda$start$0((Entity)fallingBlock, (Entity)vex, next, finishLocation, arg_0));
            }
        }, 1L, 1L);
    }

    public static void addToCheck(@NotNull SpawnedCrate crate) {
        fallingCrates.add(crate);
    }

    private static /* synthetic */ void lambda$start$0(Entity fallingBlock, Entity vex, SpawnedCrate next, Location finishLocation, ScheduledTask t) {
        fallingBlock.remove();
        vex.remove();
        next.land(finishLocation);
    }
}

