/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.lamp.util;

import com.artillexstudios.axenvoy.libs.lamp.annotation.Flag;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Named;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Switch;
import com.artillexstudios.axenvoy.libs.lamp.util.Preconditions;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    public static final Pattern SPACE = Pattern.compile(" ", 16);
    public static final Pattern VERTICAL_BAR = Pattern.compile("|", 16);
    public static final Pattern SNOWFLAKE = Pattern.compile("<(@!|@|@&|#)(?<snowflake>\\d{18})>");

    private Strings() {
    }

    public static LinkedList<String> splitBySpace(String text) {
        String[] result = SPACE.split(text);
        LinkedList<String> list = new LinkedList<String>();
        Collections.addAll(list, result);
        return list;
    }

    @Nullable
    public static String getSnowflake(String mention) {
        Matcher matcher = SNOWFLAKE.matcher(mention);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static String getOverriddenName(@NotNull Parameter parameter) {
        Named named = parameter.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        Switch switchAnn = parameter.getAnnotation(Switch.class);
        if (switchAnn != null) {
            return switchAnn.value().isEmpty() ? parameter.getName() : switchAnn.value();
        }
        Flag flag = parameter.getAnnotation(Flag.class);
        if (flag != null) {
            return flag.value().isEmpty() ? parameter.getName() : flag.value();
        }
        return null;
    }

    @NotNull
    public static String stripNamespace(String namespace, @NotNull String command) {
        int colon = command.indexOf(namespace + ':');
        if (colon == -1) {
            return command;
        }
        return command.substring(namespace.length() + 1);
    }

    @NotNull
    public static String stripNamespace(@NotNull String command) {
        int colon = command.indexOf(58);
        if (colon == -1) {
            return command;
        }
        return command.substring(colon + 1);
    }

    public static String repeat(String string, int count) {
        int n;
        Preconditions.notNull(string, "string");
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: " + count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String colorize(@NotNull String text) {
        char[] b2 = text.toCharArray();
        for (int i = 0; i < b2.length - 1; ++i) {
            if (b2[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(b2[i + 1]) <= -1) continue;
            b2[i] = 167;
            b2[i + 1] = Character.toLowerCase(b2[i + 1]);
        }
        return new String(b2);
    }
}

