/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.lamp.exception;

import com.artillexstudios.axenvoy.libs.lamp.command.CommandActor;
import com.artillexstudios.axenvoy.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axenvoy.libs.lamp.core.reflect.MethodCallerFactory;
import com.artillexstudios.axenvoy.libs.lamp.exception.ArgumentParseException;
import com.artillexstudios.axenvoy.libs.lamp.exception.CommandExceptionHandler;
import com.artillexstudios.axenvoy.libs.lamp.exception.CommandInvocationException;
import com.artillexstudios.axenvoy.libs.lamp.exception.CooldownException;
import com.artillexstudios.axenvoy.libs.lamp.exception.EnumNotFoundException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidBooleanException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidCommandException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidHelpPageException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidNumberException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidSubcommandException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidURLException;
import com.artillexstudios.axenvoy.libs.lamp.exception.InvalidUUIDException;
import com.artillexstudios.axenvoy.libs.lamp.exception.MissingArgumentException;
import com.artillexstudios.axenvoy.libs.lamp.exception.NoPermissionException;
import com.artillexstudios.axenvoy.libs.lamp.exception.NoSubcommandSpecifiedException;
import com.artillexstudios.axenvoy.libs.lamp.exception.NumberNotInRangeException;
import com.artillexstudios.axenvoy.libs.lamp.exception.SelfHandledException;
import com.artillexstudios.axenvoy.libs.lamp.exception.SendableException;
import com.artillexstudios.axenvoy.libs.lamp.exception.TooManyArgumentsException;
import com.artillexstudios.axenvoy.libs.lamp.util.ClassMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CommandExceptionAdapter
implements CommandExceptionHandler {
    private static final List<Method> IGNORED_METHODS = new ArrayList<Method>();
    private final ClassMap<MethodExceptionHandler> handlers = new ClassMap();
    private final MethodExceptionHandler unknownHandler = this::onUnhandledException;

    @Ignore
    public void onUnhandledException(@NotNull CommandActor actor, @NotNull Throwable throwable) {
    }

    public void missingArgument(@NotNull CommandActor actor, @NotNull MissingArgumentException exception) {
    }

    public void invalidEnumValue(@NotNull CommandActor actor, @NotNull EnumNotFoundException exception) {
    }

    public void invalidUUID(@NotNull CommandActor actor, @NotNull InvalidUUIDException exception) {
    }

    public void invalidNumber(@NotNull CommandActor actor, @NotNull InvalidNumberException exception) {
    }

    public void invalidURL(@NotNull CommandActor actor, @NotNull InvalidURLException exception) {
    }

    public void invalidBoolean(@NotNull CommandActor actor, @NotNull InvalidBooleanException exception) {
    }

    public void numberNotInRange(@NotNull CommandActor actor, @NotNull NumberNotInRangeException exception) {
    }

    public void noPermission(@NotNull CommandActor actor, @NotNull NoPermissionException exception) {
    }

    public void argumentParse(@NotNull CommandActor actor, @NotNull ArgumentParseException exception) {
    }

    public void commandInvocation(@NotNull CommandActor actor, @NotNull CommandInvocationException exception) {
    }

    public void tooManyArguments(@NotNull CommandActor actor, @NotNull TooManyArgumentsException exception) {
    }

    public void invalidCommand(@NotNull CommandActor actor, @NotNull InvalidCommandException exception) {
    }

    public void invalidSubcommand(@NotNull CommandActor actor, @NotNull InvalidSubcommandException exception) {
    }

    public void noSubcommandSpecified(@NotNull CommandActor actor, @NotNull NoSubcommandSpecifiedException exception) {
    }

    public void cooldown(@NotNull CommandActor actor, @NotNull CooldownException exception) {
    }

    public void invalidHelpPage(@NotNull CommandActor actor, @NotNull InvalidHelpPageException exception) {
    }

    public void sendableException(@NotNull CommandActor actor, @NotNull SendableException exception) {
    }

    @Override
    @Ignore
    public void handleException(@NotNull Throwable throwable, @NotNull CommandActor actor) {
        MethodExceptionHandler handler = this.handlers.getFlexibleOrDefault(throwable.getClass(), this.unknownHandler);
        if (handler == this.unknownHandler && throwable instanceof SelfHandledException) {
            ((SelfHandledException)((Object)throwable)).handle(actor);
        } else {
            handler.handle(actor, throwable);
        }
    }

    public CommandExceptionAdapter() {
        for (Method m : this.getClass().getMethods()) {
            this.register(m);
        }
    }

    private void register(@NotNull Method method) {
        MethodExceptionHandler handler;
        Class<?> exceptionType;
        if (!CommandExceptionAdapter.class.isAssignableFrom(method.getDeclaringClass())) {
            return;
        }
        if (method.getParameterCount() != 2) {
            return;
        }
        if (method.isAnnotationPresent(Ignore.class)) {
            return;
        }
        for (Method ignoredMethod : IGNORED_METHODS) {
            if (!method.getName().equals(ignoredMethod.getName()) || !Arrays.equals(method.getParameterTypes(), ignoredMethod.getParameterTypes())) continue;
            return;
        }
        Parameter[] parameters = method.getParameters();
        Class<?> firstType = parameters[0].getType();
        Class<?> secondType = parameters[1].getType();
        if (CommandActor.class.isAssignableFrom(firstType) && Throwable.class.isAssignableFrom(secondType)) {
            exceptionType = secondType;
            MethodCaller.BoundMethodCaller caller = MethodCallerFactory.defaultFactory().createFor(method).bindTo(this);
            handler = (xva$0, xva$1) -> caller.call(xva$0, xva$1);
        } else if (Throwable.class.isAssignableFrom(firstType) && CommandActor.class.isAssignableFrom(secondType)) {
            exceptionType = firstType;
            MethodCaller.BoundMethodCaller caller = MethodCallerFactory.defaultFactory().createFor(method).bindTo(this);
            handler = (actor, throwable) -> caller.call(throwable, actor);
        } else {
            return;
        }
        this.handlers.add(exceptionType, handler);
    }

    static {
        for (Method method : CommandExceptionAdapter.class.getDeclaredMethods()) {
            if (method.getParameterCount() != 2 || !method.isAnnotationPresent(Ignore.class)) continue;
            IGNORED_METHODS.add(method);
        }
    }

    private static interface MethodExceptionHandler {
        public void handle(@NotNull CommandActor var1, @NotNull Throwable var2);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
    }
}

