/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.lamp.bukkit.core;

import com.artillexstudios.axenvoy.libs.lamp.CommandHandler;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.core.BukkitHandler;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.exception.SenderNotConsoleException;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.exception.SenderNotPlayerException;
import com.artillexstudios.axenvoy.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axenvoy.libs.lamp.core.reflect.MethodCallerFactory;
import com.artillexstudios.axenvoy.libs.lamp.locales.Locales;
import com.artillexstudios.axenvoy.libs.lamp.util.Preconditions;
import com.artillexstudios.axenvoy.libs.lamp.util.Strings;
import com.artillexstudios.axenvoy.libs.lamp.util.Suppliers;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BukkitActor
implements BukkitCommandActor {
    private static final UUID CONSOLE_UUID = UUID.nameUUIDFromBytes("CONSOLE".getBytes(StandardCharsets.UTF_8));
    private final CommandSender sender;
    private final BukkitHandler handler;
    private static final Supplier<Optional<MethodCaller>> getLocale = Suppliers.lazy(() -> {
        try {
            Method spigotGetLocale = Player.Spigot.class.getDeclaredMethod("getLocale", new Class[0]);
            MethodCaller caller = MethodCallerFactory.defaultFactory().createFor(spigotGetLocale);
            return Optional.of(caller);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    });

    public BukkitActor(CommandSender sender, CommandHandler handler) {
        this.sender = Preconditions.notNull(sender, "sender");
        this.handler = (BukkitHandler)Preconditions.notNull(handler, "handler");
    }

    @Override
    @NotNull
    public CommandSender getSender() {
        return this.sender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    @Override
    public boolean isConsole() {
        return this.sender instanceof ConsoleCommandSender;
    }

    @Override
    @Nullable
    public Player getAsPlayer() {
        return this.isPlayer() ? (Player)this.sender : null;
    }

    @Override
    @NotNull
    public Player requirePlayer() {
        if (!this.isPlayer()) {
            throw new SenderNotPlayerException();
        }
        return (Player)this.sender;
    }

    @Override
    @NotNull
    public ConsoleCommandSender requireConsole() {
        if (!this.isConsole()) {
            throw new SenderNotConsoleException();
        }
        return (ConsoleCommandSender)this.sender;
    }

    @Override
    @NotNull
    public Audience audience() {
        if (this.sender instanceof Audience) {
            return (Audience)this.sender;
        }
        BukkitAudiences audiences = (BukkitAudiences)this.handler.bukkitAudiences;
        if (audiences == null) {
            throw new IllegalStateException("You must call BukkitCommandHandler.enableAdventure() to access this method!");
        }
        return audiences.sender(this.getSender());
    }

    @Override
    public void reply(@NotNull ComponentLike component) {
        this.audience().sendMessage(component);
    }

    @Override
    @NotNull
    public String getName() {
        return this.sender.getName();
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.sender).getUniqueId();
        }
        if (this.isConsole()) {
            return CONSOLE_UUID;
        }
        return UUID.nameUUIDFromBytes(this.getName().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void reply(@NotNull String message) {
        Preconditions.notNull(message, "message");
        this.sender.sendMessage(Strings.colorize(this.handler.getMessagePrefix() + message));
    }

    @Override
    public void error(@NotNull String message) {
        Preconditions.notNull(message, "message");
        this.sender.sendMessage(Strings.colorize(this.handler.getMessagePrefix() + "&c" + message));
    }

    @Override
    public BukkitCommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isPlayer()) {
            String playerLocale;
            try {
                playerLocale = this.requirePlayer().getLocale();
            }
            catch (NoSuchMethodError e) {
                Optional<MethodCaller> getLocale = BukkitActor.getLocale.get();
                if (getLocale.isPresent()) {
                    playerLocale = (String)getLocale.get().call(this.requirePlayer().spigot(), new Object[0]);
                }
                return BukkitCommandActor.super.getLocale();
            }
            Locale locale = Locales.get(playerLocale);
            return locale == null ? BukkitCommandActor.super.getLocale() : locale;
        }
        return BukkitCommandActor.super.getLocale();
    }
}

