/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.axapi.gui.configuration.actions.implementation;

import com.artillexstudios.axenvoy.libs.axapi.context.HashMapContext;
import com.artillexstudios.axenvoy.libs.axapi.gui.configuration.actions.Action;
import com.artillexstudios.axenvoy.libs.axapi.gui.inventory.Gui;
import com.artillexstudios.axenvoy.libs.axapi.gui.inventory.GuiKeys;
import com.artillexstudios.axenvoy.libs.axapi.gui.inventory.implementation.PaginatedGui;
import com.artillexstudios.axenvoy.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axenvoy.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axenvoy.libs.axapi.utils.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.entity.Player;

public final class PageChangeAction
extends Action<Direction> {
    public PageChangeAction(String data) {
        super(data);
    }

    @Override
    public Direction transform(String data) {
        return Direction.fetch(data);
    }

    @Override
    public void run(Player player, HashMapContext context) {
        Gui gui = context.get(GuiKeys.GUI);
        if (!(gui instanceof PaginatedGui)) {
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.debug("Gui is not a paginated gui! Gui: {}", (Object)gui);
            }
            return;
        }
        PaginatedGui paginatedGui = (PaginatedGui)gui;
        if (((Direction)this.value()).page == -1) {
            if (!paginatedGui.hasPreviousPage()) {
                if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                    LogUtils.debug("Gui has no previous page!");
                }
                return;
            }
            paginatedGui.page(paginatedGui.page() - 1);
        } else if (((Direction)this.value()).page == -2) {
            if (!paginatedGui.hasNextPage()) {
                if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                    LogUtils.debug("Gui has no next page!");
                }
                return;
            }
            paginatedGui.page(paginatedGui.page() + 1);
        } else {
            if (!paginatedGui.hasPage(((Direction)this.value()).page)) {
                if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                    LogUtils.debug("Gui has no page with index {}!", (Object)((Direction)this.value()).page);
                }
                return;
            }
            paginatedGui.page(((Direction)this.value()).page);
        }
        paginatedGui.open();
    }

    public record Direction(int page, String[] aliases) {
        private static final List<Direction> directions = new ArrayList<Direction>();
        public static final Direction BACKWARDS = Direction.register(new Direction(-1, "back", "backwards", "prev", "previous"));
        public static final Direction FORWARDS = Direction.register(new Direction(-2, "forwards", "forward", "next"));

        public static Direction register(Direction direction) {
            directions.add(direction);
            return direction;
        }

        public static Direction fetch(String directionName) {
            if (NumberUtils.isInt(directionName)) {
                return new Direction(Integer.parseInt(directionName), new String[0]);
            }
            for (Direction direction : directions) {
                if (!ArrayUtils.contains((Object[])direction.aliases, (Object)directionName)) continue;
                return direction;
            }
            return null;
        }
    }
}

