/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.axapi.config.service.implementation;

import com.artillexstudios.axenvoy.libs.axapi.config.service.Formatter;

public final class YamlFormatter
implements Formatter {
    @Override
    public String format(String toFormat) {
        StringBuilder builder = new StringBuilder();
        String[] lines = toFormat.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.strip().startsWith("#")) {
                String nextLine;
                if (this.getLeadingWhiteSpace(line) == 0 && i >= 1) {
                    builder.append("\n");
                }
                builder.append(this.toPrettyComment(line));
                builder.append("\n");
                int j = i + 1;
                while (j < lines.length && (nextLine = lines[j]).strip().startsWith("#")) {
                    builder.append(this.toPrettyComment(nextLine));
                    builder.append("\n");
                    ++j;
                    ++i;
                }
                continue;
            }
            if (i >= 1 && this.getLeadingWhiteSpace(line) < this.getLeadingWhiteSpace(lines[i - 1]) && this.getLeadingWhiteSpace(line) == 0) {
                builder.append("\n");
                builder.append(line);
                builder.append("\n");
                continue;
            }
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }

    private int getLeadingWhiteSpace(String string) {
        char ch;
        int whiteSpace = 0;
        for (int i = 0; i < string.length() && (Character.isWhitespace(ch = string.charAt(i)) || ch == '-'); ++i) {
            ++whiteSpace;
        }
        return whiteSpace;
    }

    private String toPrettyComment(String string) {
        int index = string.indexOf(35);
        if (index == -1 || index == string.length() - 1) {
            return string;
        }
        char ch = string.charAt(index + 1);
        if (Character.isWhitespace(ch)) {
            return string;
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '#') {
                builder.append('#').append(' ');
                continue;
            }
            builder.append(string.charAt(i));
        }
        return builder.toString();
    }
}

