/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.libs.axapi.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeList<E>
extends ArrayList<E> {
    private static final Logger log = LoggerFactory.getLogger(ThreadSafeList.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock read = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();

    @Override
    public int indexOf(Object o) {
        this.read.lock();
        try {
            int n = super.indexOf(o);
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read.lock();
        try {
            int n = super.lastIndexOf(o);
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        this.write.lock();
        try {
            super.add(index, element);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public E get(int index) {
        this.read.lock();
        try {
            Object e = super.get(index);
            return e;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.write.lock();
        try {
            E e = super.set(index, element);
            return e;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public E remove(int index) {
        this.write.lock();
        try {
            Object e = super.remove(index);
            return e;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.write.lock();
        try {
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.write.lock();
        try {
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.read.lock();
        try {
            super.forEach(action);
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.write.lock();
        try {
            boolean bl = super.add(e);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.write.lock();
        try {
            super.sort(c);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    @Deprecated
    public ListIterator<E> listIterator() {
        UnsupportedOperationException exception = new UnsupportedOperationException("The iterator should not be used!");
        log.warn("Unsupported operation! You should not be using any iterator from the ThreadSafeList! Advanced for loops use the iterator!", (Throwable)exception);
        return super.listIterator();
    }

    @Override
    @Deprecated
    public ListIterator<E> listIterator(int index) {
        UnsupportedOperationException exception = new UnsupportedOperationException("The iterator should not be used!");
        log.warn("Unsupported operation! You should not be using any iterator from the ThreadSafeList! Advanced for loops use the iterator!", (Throwable)exception);
        return super.listIterator(index);
    }

    @Override
    @Deprecated
    public Iterator<E> iterator() {
        UnsupportedOperationException exception = new UnsupportedOperationException("The iterator should not be used!");
        log.warn("Unsupported operation! You should not be using any iterator from the ThreadSafeList! Advanced for loops use the iterator!", (Throwable)exception);
        return super.iterator();
    }
}

