/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.envoy;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.blockfinder.BlockFinder;
import com.artillexstudios.axenvoy.blockfinder.HeightmapBlockFinder;
import com.artillexstudios.axenvoy.blockfinder.IterativeBlockFinder;
import com.artillexstudios.axenvoy.config.impl.Config;
import com.artillexstudios.axenvoy.config.impl.EnvoyConfig;
import com.artillexstudios.axenvoy.envoy.CrateType;
import com.artillexstudios.axenvoy.envoy.Crates;
import com.artillexstudios.axenvoy.envoy.Envoys;
import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import com.artillexstudios.axenvoy.event.EnvoyEndEvent;
import com.artillexstudios.axenvoy.event.EnvoyStartEvent;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.util.Pair;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axenvoy.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axenvoy.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axenvoy.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axenvoy.listeners.FlareListener;
import com.artillexstudios.axenvoy.utils.Utils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class Envoy {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private final ArrayList<Material> blacklistMaterials = new ArrayList();
    private final ArrayList<SpawnedCrate> spawnedCrates = new ArrayList();
    private final HashMap<CrateType, Double> cratesMap = new HashMap();
    private final String name;
    private final File file;
    private Location center;
    private ArrayList<Calendar> warns = new ArrayList();
    private Calendar next = Calendar.getInstance();
    private boolean active;
    private EnvoyConfig config;
    private int minCrateAmount;
    private int maxCrateAmount;
    private long startTime;
    private EnumeratedDistribution<CrateType> randomCrates;
    private boolean startAttempt = false;
    private ScheduledTask cancelTask;
    private HeightMap heightMap;
    private BlockFinder blockFinder;

    public Envoy(@NotNull File file) {
        this.file = file;
        this.name = file.getName().replace(".yml", "").replace(".yaml", "");
        Envoys.register(this);
        this.active = false;
        this.config = new EnvoyConfig("envoys/" + file.getName());
        this.config.reload();
    }

    public void reload() {
        this.config.reload();
        Location location = this.center = Utils.deserializeLocation(this.config.RANDOM_SPAWN_CENTER).getWorld() != null ? Utils.deserializeLocation(this.config.RANDOM_SPAWN_CENTER) : (Location)new ArrayList<String>(this.config.PREDEFINED_LOCATIONS).stream().map(Utils::deserializeLocation).toList().stream().findFirst().get();
        if (!this.config.SPAWN_AMOUNT.contains("-")) {
            this.minCrateAmount = this.maxCrateAmount = Integer.parseInt(this.config.SPAWN_AMOUNT);
        } else {
            String[] s = this.config.SPAWN_AMOUNT.split("-");
            this.minCrateAmount = Integer.parseInt(s[0]);
            this.maxCrateAmount = Integer.parseInt(s[1]);
        }
        this.cratesMap.clear();
        for (Map.Entry entry : this.config.CRATES.entrySet()) {
            String string = (String)entry.getKey();
            CrateType crateType = Crates.valueOf(string);
            if (crateType == null) {
                return;
            }
            this.cratesMap.put(crateType, ((Number)entry.getValue()).doubleValue());
        }
        List<String> blacklist = this.config.RANDOM_SPAWN_BLACKLISTED_MATERIALS;
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>(blacklist.size());
        for (String pattern : blacklist) {
            arrayList.add(Pattern.compile(pattern));
        }
        block10: for (Material value2 : Material.values()) {
            for (Pattern pattern : arrayList) {
                Matcher matcher = pattern.matcher(value2.name().toLowerCase(Locale.ENGLISH));
                if (!matcher.find()) continue;
                this.blacklistMaterials.add(value2);
                continue block10;
            }
        }
        ArrayList arrayList2 = new ArrayList();
        this.cratesMap.forEach((key, value) -> list.add(new Pair(key, value)));
        this.randomCrates = new EnumeratedDistribution(arrayList2);
        if (!this.config.EVERY.isBlank()) {
            this.updateNext();
        }
        try {
            this.heightMap = HeightMap.valueOf((String)this.config.HEIGHTMAP.toUpperCase(Locale.ENGLISH));
        }
        catch (EnumConstantNotPresentException exception) {
            this.heightMap = HeightMap.MOTION_BLOCKING;
        }
        this.blockFinder = switch (this.config.TOP_BLOCK_FINDER.toUpperCase(Locale.ENGLISH)) {
            case "ITERATIVE" -> new IterativeBlockFinder();
            default -> new HeightmapBlockFinder();
        };
    }

    public EnvoyConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Material> getBlacklistMaterials() {
        return this.blacklistMaterials;
    }

    public ArrayList<SpawnedCrate> getSpawnedCrates() {
        return this.spawnedCrates;
    }

    public HashMap<CrateType, Double> getCratesMap() {
        return this.cratesMap;
    }

    public File getFile() {
        return this.file;
    }

    public ArrayList<Calendar> getWarns() {
        return this.warns;
    }

    public Location getCenter() {
        return this.center;
    }

    public void updateNext() {
        this.next = Calendar.getInstance();
        if (this.config.TIMES.isEmpty()) {
            this.setCalendar(this.next, null, this.config.EVERY);
        } else {
            Calendar cld = null;
            for (String time : this.config.TIMES) {
                Date parsed;
                try {
                    parsed = dateFormat.parse(time);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                Calendar n = Calendar.getInstance();
                n.setTime(parsed);
                ZonedDateTime zoneDateTime = ZonedDateTime.now();
                zoneDateTime = zoneDateTime.withHour(n.get(11));
                zoneDateTime = zoneDateTime.withMinute(n.get(12));
                zoneDateTime = zoneDateTime.withSecond(n.get(13));
                if (zoneDateTime.isBefore(ZonedDateTime.now())) {
                    zoneDateTime = zoneDateTime.plusDays(1L);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(zoneDateTime.toInstant().toEpochMilli());
                if (cld == null) {
                    cld = calendar;
                }
                if (!calendar.before(cld)) continue;
                cld = calendar;
            }
            this.next = cld;
        }
        this.startAttempt = false;
        this.warns.clear();
        this.warns = this.updateWarns();
    }

    public void setCalendar(Calendar calendar, Calendar parent, String format) {
        if (parent != null) {
            calendar.setTimeInMillis(parent.getTimeInMillis());
            for (String s : format.split(" ")) {
                if (s.contains("d")) {
                    calendar.add(5, -Integer.parseInt(s.replace("d", "")));
                }
                if (s.contains("h")) {
                    calendar.add(10, -Integer.parseInt(s.replace("h", "")));
                }
                if (s.contains("m")) {
                    calendar.add(12, -Integer.parseInt(s.replace("m", "")));
                }
                if (!s.contains("s")) continue;
                calendar.add(13, -Integer.parseInt(s.replace("s", "")));
            }
        } else {
            for (String s : format.split(" ")) {
                if (s.contains("d")) {
                    calendar.add(5, Integer.parseInt(s.replace("d", "")));
                }
                if (s.contains("h")) {
                    calendar.add(10, Integer.parseInt(s.replace("h", "")));
                }
                if (s.contains("m")) {
                    calendar.add(12, Integer.parseInt(s.replace("m", "")));
                }
                if (!s.contains("s")) continue;
                calendar.add(13, Integer.parseInt(s.replace("s", "")));
            }
        }
    }

    public Calendar getNext() {
        return this.next;
    }

    private ArrayList<Calendar> updateWarns() {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        for (String warn : this.config.ALERT_TIMES) {
            Calendar calendar = Calendar.getInstance();
            this.setCalendar(calendar, this.getNext(), warn);
            calendars.add(calendar);
        }
        return calendars;
    }

    public boolean start(Player player) {
        Location location2;
        int i;
        if (this.center == null) {
            return false;
        }
        if (this.active) {
            return false;
        }
        this.active = true;
        this.startTime = System.currentTimeMillis();
        int crateAmount = ThreadLocalRandom.current().nextInt(this.minCrateAmount, this.maxCrateAmount + 1);
        if (this.config.PREDEFINED_SPAWNS) {
            ArrayList<Location> locations = new ArrayList<Location>(this.config.PREDEFINED_LOCATIONS.stream().map(Utils::deserializeLocation).toList());
            if (this.config.LIMIT_PREDEFINED) {
                for (i = 0; i < crateAmount; ++i) {
                    location2 = (Location)locations.get(ThreadLocalRandom.current().nextInt(locations.size()));
                    new SpawnedCrate(this, this.getRandomCrate(), location2.clone());
                    locations.remove(location2);
                    if (!locations.isEmpty()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (Location location2 : locations) {
                    new SpawnedCrate(this, this.getRandomCrate(), location2.clone());
                }
            }
        }
        if (this.config.RANDOM_SPAWN) {
            if (PaperUtils.isFolia()) {
                EXECUTOR.execute(() -> {
                    int count = crateAmount - this.spawnedCrates.size();
                    if (count > 0) {
                        for (int i = 0; i < count; ++i) {
                            Location location = null;
                            for (int tries = 0; location == null && tries < 100; ++tries) {
                                try {
                                    location = Utils.getNextLocationFolia(this, this.center.clone()).get();
                                    continue;
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (location == null) continue;
                            new SpawnedCrate(this, this.getRandomCrate(), location.clone());
                        }
                    }
                    if (player == null) {
                        if (crateAmount > 1) {
                            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.MULTIPLE_START.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z")).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z"))));
                            }
                        } else {
                            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.SINGLE_START.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ())).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ()))));
                            }
                        }
                    } else if (crateAmount > 1) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.MULTIPLE_START_FLARE.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z")).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z"))));
                        }
                    } else {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.SINGLE_START_FLARE.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ())).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ()))));
                        }
                    }
                    if (this.config.SEND_SPAWN_MESSAGES) {
                        for (SpawnedCrate spawnedCrate : this.spawnedCrates) {
                            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                if (onlinePlayer.getPersistentDataContainer().has(AxEnvoyPlugin.MESSAGE_KEY, PersistentDataType.BYTE)) continue;
                                Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.CRATE_SPAWN.replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", spawnedCrate.getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(spawnedCrate.getFinishLocation().getBlockX())).replace("%y%", String.valueOf(spawnedCrate.getFinishLocation().getBlockY())).replace("%z%", String.valueOf(spawnedCrate.getFinishLocation().getBlockZ()))));
                            }
                        }
                    }
                    if (this.config.TIMEOUT_TIME > 0) {
                        this.cancelTask = Scheduler.get().runLater(() -> {
                            if (!this.active) {
                                return;
                            }
                            this.stop();
                        }, (long)this.config.TIMEOUT_TIME * 20L);
                    }
                });
            } else {
                int count = crateAmount - this.spawnedCrates.size();
                if (count > 0) {
                    for (i = 0; i < count; ++i) {
                        location2 = null;
                        for (int tries = 0; location2 == null && tries < 100; ++tries) {
                            location2 = Utils.getNextLocation(this, this.center.clone());
                        }
                        if (location2 != null) {
                            new SpawnedCrate(this, this.getRandomCrate(), location2.clone());
                            continue;
                        }
                        if (!Config.DEBUG) continue;
                        LogUtils.debug("Reached max tries while trying to spawn crate!");
                    }
                }
                if (player == null) {
                    if (crateAmount > 1) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.MULTIPLE_START.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z")).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z"))));
                        }
                    } else {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.SINGLE_START.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ())).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ()))));
                        }
                    }
                } else if (crateAmount > 1) {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.MULTIPLE_START_FLARE.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z")).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z"))));
                    }
                } else {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.SINGLE_START_FLARE.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ())).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ()))));
                    }
                }
                if (this.config.SEND_SPAWN_MESSAGES) {
                    for (SpawnedCrate spawnedCrate : this.spawnedCrates) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            if (onlinePlayer.getPersistentDataContainer().has(AxEnvoyPlugin.MESSAGE_KEY, PersistentDataType.BYTE)) continue;
                            Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.CRATE_SPAWN.replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", spawnedCrate.getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(spawnedCrate.getFinishLocation().getBlockX())).replace("%y%", String.valueOf(spawnedCrate.getFinishLocation().getBlockY())).replace("%z%", String.valueOf(spawnedCrate.getFinishLocation().getBlockZ()))));
                        }
                    }
                }
                if (this.config.TIMEOUT_TIME > 0) {
                    this.cancelTask = Scheduler.get().runLater(() -> {
                        if (!this.active) {
                            return;
                        }
                        this.stop();
                    }, (long)this.config.TIMEOUT_TIME * 20L);
                }
            }
        } else {
            if (crateAmount > 1) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.MULTIPLE_START.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z")).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.getCenter() != null ? this.getCenter().getWorld().getName() : "world").replace("%x%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockX()) : "x")).replace("%y%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockY()) : "y")).replace("%z%", String.valueOf(this.getCenter() != null ? Integer.valueOf(this.getCenter().getBlockZ()) : "z"))));
                }
            } else {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    Utils.sendMessage((CommandSender)onlinePlayer, this.config.PREFIX, this.config.SINGLE_START.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ())).replace("%amount%", String.valueOf(this.spawnedCrates.size())).replace("%location%", this.config.LOCATION_FORMAT.replace("%world%", this.spawnedCrates.get(0).getFinishLocation().getWorld().getName()).replace("%x%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockX())).replace("%y%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockY())).replace("%z%", String.valueOf(this.spawnedCrates.get(0).getFinishLocation().getBlockZ()))));
                }
            }
            if (this.config.TIMEOUT_TIME > 0) {
                this.cancelTask = Scheduler.get().runLater(() -> {
                    if (!this.active) {
                        return;
                    }
                    this.stop();
                }, (long)this.config.TIMEOUT_TIME * 20L);
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new EnvoyStartEvent(this));
        return true;
    }

    public CrateType getRandomCrate() {
        return (CrateType)this.randomCrates.sample();
    }

    public void stop() {
        if (Config.DEBUG) {
            LogUtils.debug("Stop called from: ", (Object)new Throwable());
        }
        if (!this.active) {
            return;
        }
        if (this.cancelTask != null && !this.cancelTask.isCancelled()) {
            this.cancelTask.cancel();
            this.cancelTask = null;
        }
        Iterator<SpawnedCrate> crateIterator = this.spawnedCrates.iterator();
        while (crateIterator.hasNext()) {
            SpawnedCrate next = crateIterator.next();
            crateIterator.remove();
            next.claim(null, this, false);
        }
        Bukkit.getPluginManager().callEvent((Event)new EnvoyEndEvent(this));
        this.active = false;
        this.updateNext();
    }

    public ItemStack getFlare(int amount) {
        ItemStack item = ItemBuilder.create(this.config.FLARE_ITEM).amount(amount).get();
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(FlareListener.KEY, PersistentDataType.STRING, (Object)this.name.toLowerCase(Locale.ENGLISH));
        item.setItemMeta(meta);
        return item;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean startAttempt() {
        return this.startAttempt;
    }

    public void setStartAttempt(boolean startAttempt) {
        this.startAttempt = startAttempt;
    }

    public HeightMap heightMap() {
        return this.heightMap;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public BlockFinder blockFinder() {
        return this.blockFinder;
    }

    public ScheduledTask cancelTask() {
        return this.cancelTask;
    }
}

