/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.config.impl;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.config.AbstractConfig;
import com.artillexstudios.axenvoy.config.impl.Messages;
import com.artillexstudios.axenvoy.libs.axapi.config.Config;
import com.artillexstudios.axenvoy.utils.FileUtils;
import java.util.List;
import java.util.Map;

public class EnvoyConfig
extends Messages {
    @AbstractConfig.Key(value="crates")
    public Map<Object, Object> CRATES = Map.of("common", 50, "legendary", "30", "rare", 40);
    @AbstractConfig.Key(value="amount")
    @AbstractConfig.Comment(value={"You can also define a range, like 30-50"})
    public String SPAWN_AMOUNT = "30";
    @AbstractConfig.Key(value="limit-predefined")
    @AbstractConfig.Comment(value={"The amount cap will be used for predefined spawns aswell"})
    public boolean LIMIT_PREDEFINED = true;
    @AbstractConfig.Key(value="collect-cooldown")
    @AbstractConfig.Comment(value={"In seconds"})
    public int COLLECT_COOLDOWN = 10;
    @AbstractConfig.Key(value="collect-global-cooldown")
    @AbstractConfig.Comment(value={"Whether the cooldown should be for all crates of this envoy, or per-crate"})
    public boolean COLLECT_GLOBAL_COOLDOWN = false;
    @AbstractConfig.Key(value="broadcast-collect")
    public boolean BROADCAST_COLLECT = true;
    @AbstractConfig.Key(value="timeout-time")
    @AbstractConfig.Comment(value={"This is in seconds"})
    public int TIMEOUT_TIME = 300;
    @AbstractConfig.Key(value="every")
    @AbstractConfig.Comment(value={"Start an envoy event every hour. To disable, leave as \"\""})
    public String EVERY = "1h";
    @AbstractConfig.Key(value="top-block-finder")
    @AbstractConfig.Comment(value={"What method should we use to find the top block at a location?", "can be heightmap or iterative.", "Iterative can pass through some blocks, heightmap", "is the topmost block of the world at that location."})
    public String TOP_BLOCK_FINDER = "heightmap";
    @AbstractConfig.Key(value="send-spawn-message")
    public boolean SEND_SPAWN_MESSAGES = false;
    @AbstractConfig.Key(value="alert-times")
    public List<String> ALERT_TIMES = List.of("30m", "10m", "5s", "3s", "2s", "1s");
    @AbstractConfig.Key(value="times")
    @AbstractConfig.Comment(value={"Exact times can be defined with the HH:mm:ss format.", "This setting works only if the every setting is set to a blank value."})
    public List<String> TIMES = List.of();
    @AbstractConfig.Key(value="only-in-global")
    @AbstractConfig.Comment(value={"If there are other regions at that location other than __global__ an envoy can't spawn there"})
    public boolean ONLY_IN_GLOBAL = false;
    @AbstractConfig.Key(value="min-players")
    public int MIN_PLAYERS = 2;
    @AbstractConfig.Key(value="random-spawn.enabled")
    @AbstractConfig.Comment(value={"Should we use random spawning?"})
    public boolean RANDOM_SPAWN = true;
    @AbstractConfig.Key(value="random-spawn.center")
    @AbstractConfig.Comment(value={"The center location"})
    public String RANDOM_SPAWN_CENTER = "world;0;100;0";
    @AbstractConfig.Key(value="random-spawn.max-distance.x")
    @AbstractConfig.Comment(value={"The maximum distance from the center an envoy may spawn, x coordinate"})
    public int RANDOM_SPAWN_MAX_DISTANCE_X = 100;
    @AbstractConfig.Key(value="random-spawn.max-distance.z")
    @AbstractConfig.Comment(value={"The maximum distance from the center an envoy may spawn, z coordinate"})
    public int RANDOM_SPAWN_MAX_DISTANCE_Z = 100;
    @AbstractConfig.Key(value="random-spawn.min-distance")
    @AbstractConfig.Comment(value={"The minimum distance from the center an envoy may spawn"})
    public int RANDOM_SPAWN_MIN_DISTANCE = 20;
    @AbstractConfig.Key(value="random-spawn.min-height")
    @AbstractConfig.Comment(value={"The minimum height at which an envoy may spawn"})
    public int RANDOM_SPAWN_MIN_HEIGHT = 10;
    @AbstractConfig.Key(value="random-spawn.max-height")
    @AbstractConfig.Comment(value={"The maximum height at which an envoy may spawn"})
    public int RANDOM_SPAWN_MAX_HEIGHT = 100;
    @AbstractConfig.Key(value="random-spawn.heightmap")
    @AbstractConfig.Comment(value={"The heightmap type, refer to https://jd.papermc.io/paper/1.21.1/org/bukkit/HeightMap.html for valid inputs"})
    public String HEIGHTMAP = "MOTION_BLOCKING";
    @AbstractConfig.Key(value="random-spawn.min-distance-between-crates")
    @AbstractConfig.Comment(value={"The minimum distance that can be between crates"})
    public int RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES = 0;
    @AbstractConfig.Key(value="random-spawn.not-on-blocks")
    @AbstractConfig.Comment(value={"You can use RegEx here, to match the name of the block", "For a list of materials, visit: https://jd.papermc.io/paper/1.20/org/bukkit/Material.html"})
    public List<String> RANDOM_SPAWN_BLACKLISTED_MATERIALS = List.of("(?<!s)t?air(?!s)", "(leaves)", "(sign)", "diamond_block");
    @AbstractConfig.Key(value="rewards.use-prefix")
    @AbstractConfig.Comment(value={"If we should use prefix for message rewards of this envoy"})
    public boolean USE_PREFIX = true;
    @AbstractConfig.Key(value="time-format")
    @AbstractConfig.Comment(value={"1 - HH:MM:SS, for example 01:25:35", "2 - short format, for example 20m", "3 - text format, for example 01h 25m 35s"})
    public int TIME_FORMAT = 1;
    @AbstractConfig.Key(value="flare.enabled")
    public boolean FLARE_ENABLED = true;
    @AbstractConfig.Key(value="flare.cooldown")
    @AbstractConfig.Comment(value={"In seconds"})
    public int FLARE_COOLDOWN = 30;
    @AbstractConfig.Key(value="flare.item")
    public Map<Object, Object> FLARE_ITEM = Map.of("material", "prismarine_shard", "name", "&cEnvoy flare", "glow", true, "custom-model-data", 0, "lore", List.of("&7Right click with this, to start", "&7the default envoy!"));
    @AbstractConfig.Key(value="pre-defined-spawns.enabled")
    public boolean PREDEFINED_SPAWNS = false;
    @AbstractConfig.Key(value="pre-defined-spawns.locations")
    public List<String> PREDEFINED_LOCATIONS = List.of("world;1;1;1");

    public EnvoyConfig(String fileName) {
        super(fileName);
    }

    @Override
    public void reload() {
        Config config = new Config(FileUtils.PLUGIN_DIRECTORY.resolve(this.fileName).toFile());
        if (config.getBackingDocument().isInt("random-spawn.max-distance")) {
            int maxDistance = config.getInt("random-spawn.max-distance");
            config.getBackingDocument().remove("random-spawn.max-distance");
            config.set("random-spawn.max-distance.x", maxDistance);
            config.set("random-spawn.max-distance.z", maxDistance);
            config.save();
        }
        this.reload(FileUtils.PLUGIN_DIRECTORY.resolve(this.fileName), Messages.class, this, AxEnvoyPlugin.getMessages());
        this.reload(FileUtils.PLUGIN_DIRECTORY.resolve(this.fileName), EnvoyConfig.class, this, null);
    }
}

