/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.commands;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.envoy.Envoys;
import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.util.Pair;
import com.artillexstudios.axenvoy.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axenvoy.libs.axapi.utils.StringUtils;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Command;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Default;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Optional;
import com.artillexstudios.axenvoy.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axenvoy.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axenvoy.user.User;
import com.artillexstudios.axenvoy.utils.Utils;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

@Command(value={"envoy", "axenvoy", "axen", "envoys"})
public class EnvoyCommand {
    @Subcommand(value={"flare"})
    @CommandPermission(value="axenvoy.command.flare")
    public void flare(CommandSender sender, Envoy envoy, @Default(value={"me"}) Player receiver, @Default(value={"1"}) int amount) {
        if (envoy == null) {
            Utils.sendMessage(sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().NO_ENVOY_FOUND);
            return;
        }
        ItemStack item = envoy.getFlare(amount);
        receiver.getInventory().addItem(new ItemStack[]{item});
    }

    @Subcommand(value={"start"})
    @CommandPermission(value="axenvoy.command.start")
    public void start(CommandSender sender, Envoy envoy) {
        if (envoy == null) {
            Utils.sendMessage(sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().NO_ENVOY_FOUND);
            return;
        }
        envoy.start(null);
    }

    @Subcommand(value={"stop"})
    @CommandPermission(value="axenvoy.command.stop")
    public void stop(CommandSender sender, Envoy envoy) {
        if (envoy == null) {
            Utils.sendMessage(sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().NO_ENVOY_FOUND);
            return;
        }
        if (!envoy.isActive()) {
            return;
        }
        envoy.stop();
    }

    @Subcommand(value={"stopall"})
    @CommandPermission(value="axenvoy.command.stopall")
    public void stopAll(CommandSender sender) {
        for (Envoy envoy : Envoys.getTypes().values()) {
            if (!envoy.isActive()) {
                return;
            }
            envoy.stop();
        }
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="axenvoy.command.reload")
    public void reload(CommandSender sender) {
        Utils.sendMessage(sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().RELOAD.replace("%time%", String.valueOf(AxEnvoyPlugin.getInstance().reloadWithTime())));
    }

    @Subcommand(value={"center"})
    @CommandPermission(value="axenvoy.command.center")
    public void center(Player sender, Envoy envoy) {
        if (envoy == null) {
            Utils.sendMessage((CommandSender)sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().NO_ENVOY_FOUND);
            return;
        }
        envoy.getConfig().getConfig().set("random-spawn.center", Utils.serializeLocation(sender.getLocation()));
        try {
            envoy.getConfig().getConfig().save();
            envoy.getConfig().reload();
            Utils.sendMessage((CommandSender)sender, envoy.getConfig().PREFIX, envoy.getConfig().SET_CENTER);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Subcommand(value={"editor"})
    @CommandPermission(value="axenvoy.command.editor")
    public void editor(Player sender, @Optional Envoy envoy) {
        User user = User.USER_MAP.get(sender.getUniqueId());
        Envoy editor = user.getEditor();
        if (envoy == null || envoy.equals(editor)) {
            user.setEditor(null);
            if (editor != null) {
                List<Location> locations = editor.getConfig().PREDEFINED_LOCATIONS.stream().map(Utils::deserializeLocation).toList();
                for (Location location : locations) {
                    sender.sendBlockChange(location, Material.AIR.createBlockData());
                }
                sender.getInventory().remove(new ItemStack(Material.DIAMOND_BLOCK, 1));
                Utils.sendMessage((CommandSender)sender, editor.getConfig().PREFIX, editor.getConfig().EDITOR_LEAVE);
            }
            return;
        }
        user.setEditor(envoy);
        List<Location> locations = envoy.getConfig().PREDEFINED_LOCATIONS.stream().map(Utils::deserializeLocation).toList();
        for (Location location : locations) {
            sender.sendBlockChange(location, Material.DIAMOND_BLOCK.createBlockData());
        }
        sender.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND_BLOCK)});
        Utils.sendMessage((CommandSender)sender, envoy.getConfig().PREFIX, envoy.getConfig().EDITOR_JOIN);
    }

    @Subcommand(value={"coords"})
    @CommandPermission(value="axenvoy.command.coords")
    public void coords(CommandSender sender, Envoy envoy) {
        if (envoy == null) {
            Utils.sendMessage(sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().NO_ENVOY_FOUND);
            return;
        }
        for (SpawnedCrate spawnedCrate : envoy.getSpawnedCrates()) {
            Location finish = spawnedCrate.getFinishLocation();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                wrapper.message(MiniMessage.miniMessage().deserialize("<click:run_command:'/tp %x% %y% %z%'><hover:show_text:'<color:#7df0ff>Click to teleport!</color>'><white>Crate</white> %crate% %x% %y% %z%.</hover></click>".replace("%x%", String.valueOf(finish.getBlockX())).replace("%y%", String.valueOf(finish.getBlockY())).replace("%z%", String.valueOf(finish.getBlockZ())).replace("%crate%", String.valueOf(spawnedCrate.getHandle().getName()))));
                continue;
            }
            sender.sendMessage(StringUtils.formatToString("<click:run_command:'/tp %x% %y% %z%'><hover:show_text:'<color:#7df0ff>Click to teleport!</color>'><white>Crate</white> %crate% %x% %y% %z%.</hover></click>".replace("%x%", String.valueOf(finish.getBlockX())).replace("%y%", String.valueOf(finish.getBlockY())).replace("%z%", String.valueOf(finish.getBlockZ())).replace("%crate%", String.valueOf(spawnedCrate.getHandle().getName())), new TagResolver[0]));
        }
    }

    @Subcommand(value={"toggle"})
    @CommandPermission(value="axenvoy.command.toggle")
    public void toggle(Player sender) {
        if (sender.getPersistentDataContainer().has(AxEnvoyPlugin.MESSAGE_KEY, PersistentDataType.BYTE)) {
            sender.getPersistentDataContainer().remove(AxEnvoyPlugin.MESSAGE_KEY);
            Utils.sendMessage((CommandSender)sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().TOGGLE_ON);
            return;
        }
        sender.getPersistentDataContainer().set(AxEnvoyPlugin.MESSAGE_KEY, PersistentDataType.BYTE, (Object)0);
        Utils.sendMessage((CommandSender)sender, AxEnvoyPlugin.getMessages().PREFIX, AxEnvoyPlugin.getMessages().TOGGLE_OFF);
    }

    @Subcommand(value={"time"})
    @CommandPermission(value="axenvoy.command.time")
    public void time(CommandSender sender) {
        Pair<Envoy, Long> pair = Utils.getNextEnvoy();
        Utils.sendMessage(sender, ((Envoy)pair.getFirst()).getConfig().PREFIX, ((Envoy)pair.getFirst()).getConfig().START_TIME.replace("%time%", Utils.fancyTime((Long)pair.getSecond(), (Envoy)pair.getFirst())).replace("%envoy%", ((Envoy)pair.getFirst()).getName()));
    }
}

