/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.utils;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.config.impl.Config;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.envoy.Envoys;
import com.artillexstudios.axenvoy.envoy.SpawnedCrate;
import com.artillexstudios.axenvoy.libs.axapi.libs.math3.util.Pair;
import com.artillexstudios.axenvoy.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axenvoy.libs.axapi.utils.StringUtils;
import com.artillexstudios.axenvoy.libs.axapi.utils.logging.LogUtils;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import java.awt.geom.Point2D;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    @NotNull
    public static Location deserializeLocation(@NotNull String locationString) {
        String[] split = locationString.split(";");
        World world = Bukkit.getWorld((String)split[0]);
        return new Location(world, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]), 0.0f, 0.0f);
    }

    public static String serializeLocation(@NotNull Location location) {
        return "%s;%s;%s;%s".formatted(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static Location getNextLocation(Envoy envoy, Location loc) {
        Location loc2;
        ApplicableRegionSet regions;
        Location center = loc.clone();
        loc.setX((double)(loc.getBlockX() + ThreadLocalRandom.current().nextInt(envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_X * -1, envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_X)));
        loc.setZ((double)(loc.getBlockZ() + ThreadLocalRandom.current().nextInt(envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_Z * -1, envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_Z)));
        if (loc.distanceSquared(center) < (double)(envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE * envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE)) {
            if (Config.DEBUG) {
                LogUtils.debug("Smaller than min distance!");
            }
            return null;
        }
        if (envoy.getConfig().ONLY_IN_GLOBAL && AxEnvoyPlugin.getInstance().isWorldGuard() && !(regions = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)loc.getWorld())).getApplicableRegions(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()))).getRegions().isEmpty()) {
            if (Config.DEBUG) {
                LogUtils.debug("Only in global region!");
            }
            return null;
        }
        if (envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES > 0) {
            for (SpawnedCrate spawnedCrate : envoy.getSpawnedCrates()) {
                if (!(Point2D.distanceSq(spawnedCrate.getFinishLocation().getX(), spawnedCrate.getFinishLocation().getZ(), loc.getX(), loc.getZ()) < (double)(envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES * envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES))) continue;
                if (Config.DEBUG) {
                    LogUtils.debug("Distance between crates is too low!");
                }
                return null;
            }
        }
        if ((loc2 = envoy.blockFinder().highestBlockAt(loc, envoy.getConfig()).getLocation()).getY() < (double)envoy.getConfig().RANDOM_SPAWN_MIN_HEIGHT) {
            if (Config.DEBUG) {
                LogUtils.debug("Smaller than min height!");
            }
            return null;
        }
        if (loc2.getY() > (double)envoy.getConfig().RANDOM_SPAWN_MAX_HEIGHT) {
            if (Config.DEBUG) {
                LogUtils.debug("Above max height");
            }
            return null;
        }
        if (!loc.getChunk().isLoaded() && !loc.getChunk().load()) {
            if (Config.DEBUG) {
                LogUtils.debug("Chunk is not loaded!");
            }
            return null;
        }
        for (SpawnedCrate spawnedCrate : envoy.getSpawnedCrates()) {
            if (spawnedCrate.getFinishLocation().getBlockX() != loc2.getBlockX() || spawnedCrate.getFinishLocation().getBlockY() != loc2.getBlockY() || spawnedCrate.getFinishLocation().getBlockZ() != loc2.getBlockZ()) continue;
            if (Config.DEBUG) {
                LogUtils.debug("Crate already exists there!");
            }
            return null;
        }
        Location location = loc2.clone();
        if (envoy.getBlacklistMaterials().contains(location.add(0.0, -1.0, 0.0).getBlock().getType())) {
            if (Config.DEBUG) {
                LogUtils.debug("Blacklisted block!");
            }
            return null;
        }
        return loc2;
    }

    public static void sendMessage(CommandSender sender, String prefix, String message) {
        if (!message.isBlank()) {
            sender.sendMessage(StringUtils.formatToString(prefix + message, new TagResolver[0]));
        }
    }

    public static CompletableFuture<Location> getNextLocationFolia(@NotNull Envoy envoy, @NotNull Location loc) {
        ApplicableRegionSet regions;
        CompletableFuture<Location> locationCompletableFuture = new CompletableFuture<Location>();
        Location center = loc.clone();
        loc.setX((double)(loc.getBlockX() + ThreadLocalRandom.current().nextInt(envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_X * -1, envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_X)));
        loc.setZ((double)(loc.getBlockZ() + ThreadLocalRandom.current().nextInt(envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_Z * -1, envoy.getConfig().RANDOM_SPAWN_MAX_DISTANCE_Z)));
        if (loc.distanceSquared(center) < (double)(envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE * envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE)) {
            locationCompletableFuture.complete(null);
        }
        if (envoy.getConfig().ONLY_IN_GLOBAL && AxEnvoyPlugin.getInstance().isWorldGuard() && !(regions = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)loc.getWorld())).getApplicableRegions(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()))).getRegions().isEmpty()) {
            locationCompletableFuture.complete(null);
        }
        if (envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES > 0) {
            for (SpawnedCrate spawnedCrate : envoy.getSpawnedCrates()) {
                if (!(spawnedCrate.getFinishLocation().distanceSquared(loc) < (double)(envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES * envoy.getConfig().RANDOM_SPAWN_MIN_DISTANCE_BETWEEN_CRATES))) continue;
                locationCompletableFuture.complete(null);
            }
        }
        Scheduler.get().runAt(loc, task -> {
            Location loc2 = envoy.blockFinder().highestBlockAt(loc, envoy.getConfig()).getLocation();
            if (loc2.getY() < (double)envoy.getConfig().RANDOM_SPAWN_MIN_HEIGHT) {
                locationCompletableFuture.complete(null);
            }
            if (loc2.getY() > (double)envoy.getConfig().RANDOM_SPAWN_MAX_HEIGHT) {
                locationCompletableFuture.complete(null);
            }
            if (!loc.getChunk().isLoaded() && !loc.getChunk().load()) {
                locationCompletableFuture.complete(null);
            }
            Location tempLoc = loc2.clone();
            if (envoy.getBlacklistMaterials().contains(tempLoc.add(0.0, -1.0, 0.0).getBlock().getType())) {
                locationCompletableFuture.complete(null);
            }
            locationCompletableFuture.complete(loc2);
        });
        return locationCompletableFuture;
    }

    @NotNull
    public static Location topBlock(@NotNull Location loc, HeightMap heightMap) {
        return loc.getWorld().getHighestBlockAt(loc, heightMap).getLocation().add(0.0, 1.0, 0.0);
    }

    @NotNull
    public static String fancyTime(long time, Envoy envoy) {
        if (time < 0L) {
            return "---";
        }
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long days = total / 86400L;
        long hours = total % 86400L / 3600L;
        long minutes = total % 3600L / 60L;
        long seconds = total % 60L;
        if (envoy.getConfig().TIME_FORMAT == 1) {
            if (days > 0L) {
                return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
            }
            if (hours > 0L) {
                return String.format("%02d:%02d:%02d", hours, minutes, seconds);
            }
            return String.format("%02d:%02d", minutes, seconds);
        }
        if (envoy.getConfig().TIME_FORMAT == 2) {
            if (days > 0L) {
                return days + envoy.getConfig().DAY;
            }
            if (hours > 0L) {
                return hours + envoy.getConfig().HOUR;
            }
            if (minutes > 0L) {
                return minutes + envoy.getConfig().MINUTE;
            }
            return seconds + envoy.getConfig().SECOND;
        }
        if (days > 0L) {
            return String.format("%02d" + envoy.getConfig().DAY + " %02d" + envoy.getConfig().HOUR + " %02d" + envoy.getConfig().MINUTE + " %02d" + envoy.getConfig().SECOND, days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02d" + envoy.getConfig().HOUR + " %02d" + envoy.getConfig().MINUTE + " %02d" + envoy.getConfig().SECOND, hours, minutes, seconds);
        }
        return String.format("%02d" + envoy.getConfig().MINUTE + " %02d" + envoy.getConfig().SECOND, minutes, seconds);
    }

    public static Pair<Envoy, Long> getNextEnvoy() {
        AtomicReference next = new AtomicReference();
        Envoys.getTypes().values().forEach(envoy -> {
            Envoy currNext = (Envoy)next.get();
            if (currNext != null && envoy.getNext().before(currNext.getNext())) {
                next.set(envoy);
            } else if (currNext == null) {
                next.set(envoy);
            }
        });
        return Pair.create((Object)((Envoy)next.get()), (Object)(((Envoy)next.get()).getNext().getTimeInMillis() - System.currentTimeMillis()));
    }
}

