/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axenvoy.user;

import com.artillexstudios.axenvoy.AxEnvoyPlugin;
import com.artillexstudios.axenvoy.envoy.CrateType;
import com.artillexstudios.axenvoy.envoy.Envoy;
import com.artillexstudios.axenvoy.user.CrateCooldown;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class User {
    public static final HashMap<UUID, User> USER_MAP = new HashMap();
    private final ArrayList<CrateCooldown> crateCooldowns = new ArrayList();
    private final ArrayList<CrateCooldown> damageCooldowns = new ArrayList();
    private final HashMap<Envoy, Long> flareCooldown = new HashMap();
    private final Player player;
    private Envoy editor = null;

    public User(@NotNull Player player) {
        this.player = player;
        USER_MAP.put(player.getUniqueId(), this);
    }

    public static void listen() {
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerJoinEvent(@NotNull PlayerJoinEvent event) {
                new User(event.getPlayer());
            }

            @EventHandler
            public void onPlayerQuitEvent(@NotNull PlayerQuitEvent event) {
                User user = USER_MAP.remove(event.getPlayer().getUniqueId());
                if (user != null) {
                    user.clear();
                }
            }
        }, (Plugin)AxEnvoyPlugin.getInstance());
    }

    public void clear() {
        this.crateCooldowns.clear();
        this.flareCooldown.clear();
    }

    public void addCrateCooldown(CrateType crateType, long seconds, Envoy envoy) {
        if (!envoy.getConfig().COLLECT_GLOBAL_COOLDOWN) {
            this.crateCooldowns.add(new CrateCooldown(envoy, crateType, System.currentTimeMillis() + seconds * 1000L));
        } else {
            this.crateCooldowns.add(new CrateCooldown(envoy, null, System.currentTimeMillis() + seconds * 1000L));
        }
    }

    public void addFlareCooldown(Envoy envoy, long seconds) {
        this.flareCooldown.put(envoy, System.currentTimeMillis() + seconds * 1000L);
    }

    public boolean canCollect(Envoy envoy, CrateType crateType) {
        return (this.getCollectCooldown(envoy, crateType) - System.currentTimeMillis()) / 1000L == 0L;
    }

    public boolean canDamage(Envoy envoy, CrateType crateType) {
        return (this.getDamageCooldown(envoy, crateType) - System.currentTimeMillis()) / 50L == 0L;
    }

    public boolean canUseFlare(Envoy envoy) {
        long cooldown = this.flareCooldown.getOrDefault(envoy, System.currentTimeMillis());
        return cooldown <= System.currentTimeMillis();
    }

    public void addDamageCooldown(CrateType crateType, long ticks, Envoy envoy) {
        this.damageCooldowns.add(new CrateCooldown(envoy, crateType, System.currentTimeMillis() + ticks * 50L));
    }

    public long getDamageCooldown(Envoy envoy, CrateType crateType) {
        Iterator<CrateCooldown> cooldownIterator = this.damageCooldowns.iterator();
        while (cooldownIterator.hasNext()) {
            CrateCooldown next = cooldownIterator.next();
            if (next.envoy != envoy) continue;
            if (next.end <= System.currentTimeMillis()) {
                cooldownIterator.remove();
                continue;
            }
            if (next.crateType != crateType) continue;
            return next.end;
        }
        return System.currentTimeMillis();
    }

    public long getCollectCooldown(Envoy envoy, CrateType crateType) {
        Iterator<CrateCooldown> cooldownIterator = this.crateCooldowns.iterator();
        while (cooldownIterator.hasNext()) {
            CrateCooldown next = cooldownIterator.next();
            if (next.envoy != envoy) continue;
            if (next.end <= System.currentTimeMillis()) {
                cooldownIterator.remove();
                continue;
            }
            if (envoy.getConfig().COLLECT_GLOBAL_COOLDOWN) {
                return next.end;
            }
            if (next.crateType != crateType) continue;
            return next.end;
        }
        return System.currentTimeMillis();
    }

    public void setEditor(Envoy value) {
        this.editor = value;
    }

    public Envoy getEditor() {
        return this.editor;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (!this.getPlayer().equals((Object)user.getPlayer())) {
            return false;
        }
        return this.getEditor() != null ? this.getEditor().equals(user.getEditor()) : user.getEditor() == null;
    }

    public int hashCode() {
        int result = this.getPlayer().hashCode();
        result = 31 * result + (this.getEditor() != null ? this.getEditor().hashCode() : 0);
        return result;
    }
}

